/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor.type.field;

import com.bluelinelabs.logansquare.processor.type.field.NumberFieldType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class FloatFieldType
extends NumberFieldType {
    public FloatFieldType(boolean isPrimitive) {
        super(isPrimitive);
    }

    @Override
    public TypeName getTypeName() {
        return this.isPrimitive ? TypeName.FLOAT : ClassName.get(Float.class);
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return ClassName.get(Float.class);
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        if (this.isPrimitive) {
            setter = FloatFieldType.replaceLastLiteral(setter, "(float)$L.getValueAsDouble()");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
        } else {
            setter = FloatFieldType.replaceLastLiteral(setter, "$L.getCurrentToken() == $T.VALUE_NULL ? null : new Float($L.getValueAsDouble())");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser", JsonToken.class, "jsonParser"));
        }
    }
}

