/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor.type.field;

import com.bluelinelabs.logansquare.processor.ObjectMapperInjector;
import com.bluelinelabs.logansquare.processor.type.Type;
import com.bluelinelabs.logansquare.processor.type.field.FieldType;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Set;

public class JsonFieldType
extends FieldType {
    private final ClassName mClassName;
    private final String mMapperClassName;
    private final String mMapperVariableName;

    public JsonFieldType(ClassName className) {
        this.mClassName = className;
        this.mMapperClassName = this.mClassName.toString() + "$$JsonObjectMapper";
        this.mMapperVariableName = ObjectMapperInjector.getMapperVariableName(this.mMapperClassName);
    }

    @Override
    public TypeName getTypeName() {
        return this.mClassName;
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return this.mClassName;
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        setter = JsonFieldType.replaceLastLiteral(setter, "$L.parse($L)");
        builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, this.mMapperVariableName, "jsonParser"));
    }

    @Override
    public void serialize(MethodSpec.Builder builder, int depth, String fieldName, List<String> processedFieldNames, String getter, boolean isObjectProperty, boolean checkIfNull, boolean writeIfNull, boolean writeCollectionElementIfNull) {
        if (checkIfNull) {
            builder.beginControlFlow("if ($L != null)", new Object[]{getter});
        }
        if (isObjectProperty) {
            builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
        }
        builder.addStatement("$L.serialize($L, $L, true)", new Object[]{this.mMapperVariableName, getter, "jsonGenerator"});
        if (checkIfNull) {
            if (writeIfNull) {
                builder.nextControlFlow("else", new Object[0]);
                if (isObjectProperty) {
                    builder.addStatement("$L.writeFieldName($S)", new Object[]{"jsonGenerator", fieldName});
                }
                builder.addStatement("$L.writeNull()", new Object[]{"jsonGenerator"});
            }
            builder.endControlFlow();
        }
    }

    @Override
    public Set<Type.ClassNameObjectMapper> getUsedJsonObjectMappers() {
        Set<Type.ClassNameObjectMapper> set = super.getUsedJsonObjectMappers();
        set.add(new Type.ClassNameObjectMapper(this.mClassName, this.mMapperClassName));
        return set;
    }
}

