/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.processor.type.field;

import com.bluelinelabs.logansquare.processor.type.field.NumberFieldType;
import com.fasterxml.jackson.core.JsonToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;

public class LongFieldType
extends NumberFieldType {
    public LongFieldType(boolean isPrimitive) {
        super(isPrimitive);
    }

    @Override
    public TypeName getTypeName() {
        return this.isPrimitive ? TypeName.LONG : ClassName.get(Long.class);
    }

    @Override
    public TypeName getNonPrimitiveTypeName() {
        return ClassName.get(Long.class);
    }

    @Override
    public void parse(MethodSpec.Builder builder, int depth, String setter, Object ... setterFormatArgs) {
        if (this.isPrimitive) {
            setter = LongFieldType.replaceLastLiteral(setter, "$L.getValueAsLong()");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser"));
        } else {
            setter = LongFieldType.replaceLastLiteral(setter, "$L.getCurrentToken() == $T.VALUE_NULL ? null : Long.valueOf($L.getValueAsLong())");
            builder.addStatement(setter, this.expandStringArgs(setterFormatArgs, "jsonParser", JsonToken.class, "jsonParser"));
        }
    }
}

