/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare;

import com.bluelinelabs.logansquare.JsonMapper;
import com.bluelinelabs.logansquare.NoSuchMapperException;
import com.bluelinelabs.logansquare.NoSuchTypeConverterException;
import com.bluelinelabs.logansquare.typeconverters.DefaultCalendarConverter;
import com.bluelinelabs.logansquare.typeconverters.DefaultDateConverter;
import com.bluelinelabs.logansquare.typeconverters.TypeConverter;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoganSquare {
    private static final Map<Class, JsonMapper> OBJECT_MAPPERS = new HashMap<Class, JsonMapper>();
    private static final Map<Class, TypeConverter> TYPE_CONVERTERS = new HashMap<Class, TypeConverter>();
    public static final JsonFactory JSON_FACTORY;

    public static <E> E parse(InputStream is, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parse(is);
    }

    public static <E> E parse(String jsonString, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parse(jsonString);
    }

    public static <E> List<E> parseList(InputStream is, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parseList(is);
    }

    public static <E> List<E> parseList(String jsonString, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parseList(jsonString);
    }

    public static <E> Map<String, E> parseMap(InputStream is, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parseMap(is);
    }

    public static <E> Map<String, E> parseMap(String jsonString, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).parseMap(jsonString);
    }

    public static <E> String serialize(E object) throws IOException {
        return LoganSquare.mapperFor(object.getClass()).serialize(object);
    }

    public static <E> void serialize(E object, OutputStream os) throws IOException {
        LoganSquare.mapperFor(object.getClass()).serialize(object, os);
    }

    public static <E> String serialize(List<E> list, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).serialize(list);
    }

    public static <E> void serialize(List<E> list, OutputStream os, Class<E> jsonObjectClass) throws IOException {
        LoganSquare.mapperFor(jsonObjectClass).serialize(list, os);
    }

    public static <E> String serialize(Map<String, E> map, Class<E> jsonObjectClass) throws IOException {
        return LoganSquare.mapperFor(jsonObjectClass).serialize(map);
    }

    public static <E> void serialize(Map<String, E> map, OutputStream os, Class<E> jsonObjectClass) throws IOException {
        LoganSquare.mapperFor(jsonObjectClass).serialize(map, os);
    }

    public static <E> JsonMapper<E> mapperFor(Class<E> cls) throws NoSuchMapperException {
        JsonMapper mapper = OBJECT_MAPPERS.get(cls);
        if (mapper == null) {
            try {
                Class<?> mapperClass = Class.forName(cls.getName() + "$$JsonObjectMapper");
                mapper = (JsonMapper)mapperClass.newInstance();
                OBJECT_MAPPERS.put(cls, mapper);
            }
            catch (Exception e) {
                throw new NoSuchMapperException(cls, e);
            }
        }
        return mapper;
    }

    public static <E> TypeConverter<E> typeConverterFor(Class<E> cls) throws NoSuchTypeConverterException {
        TypeConverter typeConverter = TYPE_CONVERTERS.get(cls);
        if (typeConverter == null) {
            throw new NoSuchTypeConverterException(cls);
        }
        return typeConverter;
    }

    public static <E> void registerTypeConverter(Class<E> cls, TypeConverter<E> converter) {
        TYPE_CONVERTERS.put(cls, converter);
    }

    static {
        LoganSquare.registerTypeConverter(Date.class, new DefaultDateConverter());
        LoganSquare.registerTypeConverter(Calendar.class, new DefaultCalendarConverter());
        JSON_FACTORY = new JsonFactory();
    }
}

