/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.typeconverters;

import com.bluelinelabs.logansquare.typeconverters.TypeConverter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public abstract class DateTypeConverter
implements TypeConverter<Date> {
    private static final Object FORMATTER_LOCK = new Object();

    public abstract DateFormat getDateFormat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date parse(JsonParser jsonParser) throws IOException {
        String dateString = jsonParser.getValueAsString(null);
        try {
            Object object = FORMATTER_LOCK;
            synchronized (object) {
                return this.getDateFormat().parse(dateString);
            }
        }
        catch (ParseException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Date object, String fieldName, boolean writeFieldNameForObject, JsonGenerator jsonGenerator) throws IOException {
        Object object2 = FORMATTER_LOCK;
        synchronized (object2) {
            jsonGenerator.writeStringField(fieldName, this.getDateFormat().format(object));
        }
    }
}

