/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare;

import com.bluelinelabs.logansquare.LoganSquare;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class JsonMapper<T> {
    public abstract T parse(JsonParser var1) throws IOException;

    public abstract void parseField(T var1, String var2, JsonParser var3) throws IOException;

    public abstract void serialize(T var1, JsonGenerator var2, boolean var3) throws IOException;

    public T parse(InputStream is) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(is);
        jsonParser.nextToken();
        return this.parse(jsonParser);
    }

    public T parse(byte[] byteArray) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(byteArray);
        jsonParser.nextToken();
        return this.parse(jsonParser);
    }

    public T parse(char[] charArray) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(charArray);
        jsonParser.nextToken();
        return this.parse(jsonParser);
    }

    public T parse(String jsonString) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(jsonString);
        jsonParser.nextToken();
        return this.parse(jsonParser);
    }

    public List<T> parseList(InputStream is) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(is);
        jsonParser.nextToken();
        return this.parseList(jsonParser);
    }

    public List<T> parseList(byte[] byteArray) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(byteArray);
        jsonParser.nextToken();
        return this.parseList(jsonParser);
    }

    public List<T> parseList(char[] charArray) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(charArray);
        jsonParser.nextToken();
        return this.parseList(jsonParser);
    }

    public List<T> parseList(String jsonString) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(jsonString);
        jsonParser.nextToken();
        return this.parseList(jsonParser);
    }

    public List<T> parseList(JsonParser jsonParser) throws IOException {
        ArrayList<T> list = new ArrayList<T>();
        if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
            while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                list.add(this.parse(jsonParser));
            }
        }
        return list;
    }

    public Map<String, T> parseMap(InputStream is) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(is);
        jsonParser.nextToken();
        return this.parseMap(jsonParser);
    }

    public Map<String, T> parseMap(byte[] byteArray) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(byteArray);
        jsonParser.nextToken();
        return this.parseMap(jsonParser);
    }

    public Map<String, T> parseMap(char[] charArray) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(charArray);
        jsonParser.nextToken();
        return this.parseMap(jsonParser);
    }

    public Map<String, T> parseMap(String jsonString) throws IOException {
        JsonParser jsonParser = LoganSquare.JSON_FACTORY.createParser(jsonString);
        jsonParser.nextToken();
        return this.parseMap(jsonParser);
    }

    public Map<String, T> parseMap(JsonParser jsonParser) throws IOException {
        HashMap<String, T> map = new HashMap<String, T>();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String key = jsonParser.getText();
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                map.put(key, null);
                continue;
            }
            map.put(key, this.parse(jsonParser));
        }
        return map;
    }

    public String serialize(T object) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jsonGenerator = LoganSquare.JSON_FACTORY.createGenerator((Writer)sw);
        this.serialize(object, jsonGenerator, true);
        jsonGenerator.close();
        return sw.toString();
    }

    public void serialize(T object, OutputStream os) throws IOException {
        JsonGenerator jsonGenerator = LoganSquare.JSON_FACTORY.createGenerator(os);
        this.serialize(object, jsonGenerator, true);
        jsonGenerator.close();
    }

    public String serialize(List<T> list) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jsonGenerator = LoganSquare.JSON_FACTORY.createGenerator((Writer)sw);
        this.serialize(list, jsonGenerator);
        jsonGenerator.close();
        return sw.toString();
    }

    public void serialize(List<T> list, OutputStream os) throws IOException {
        JsonGenerator jsonGenerator = LoganSquare.JSON_FACTORY.createGenerator(os);
        this.serialize(list, jsonGenerator);
        jsonGenerator.close();
    }

    public void serialize(List<T> list, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
        for (T object : list) {
            if (object != null) {
                this.serialize(object, jsonGenerator, true);
                continue;
            }
            jsonGenerator.writeNull();
        }
        jsonGenerator.writeEndArray();
    }

    public String serialize(Map<String, T> map) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jsonGenerator = LoganSquare.JSON_FACTORY.createGenerator((Writer)sw);
        this.serialize(map, jsonGenerator);
        jsonGenerator.close();
        return sw.toString();
    }

    public void serialize(Map<String, T> map, OutputStream os) throws IOException {
        JsonGenerator jsonGenerator = LoganSquare.JSON_FACTORY.createGenerator(os);
        this.serialize(map, jsonGenerator);
        jsonGenerator.close();
    }

    public void serialize(Map<String, T> map, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            if (entry.getValue() == null) {
                jsonGenerator.writeNull();
                continue;
            }
            this.serialize(entry.getValue(), jsonGenerator, true);
        }
        jsonGenerator.writeEndObject();
    }
}

