/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare.typeconverters;

import com.bluelinelabs.logansquare.typeconverters.TypeConverter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public abstract class DateTypeConverter
implements TypeConverter<Date> {
    private final ThreadLocal<DateFormat> mDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateTypeConverter.this.getDateFormat();
        }
    };

    @Override
    public Date parse(JsonParser jsonParser) throws IOException {
        String dateString = jsonParser.getValueAsString(null);
        if (dateString != null) {
            try {
                return this.mDateFormat.get().parse(dateString);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void serialize(Date object, String fieldName, boolean writeFieldNameForObject, JsonGenerator jsonGenerator) throws IOException {
        if (fieldName != null && object != null) {
            jsonGenerator.writeStringField(fieldName, this.mDateFormat.get().format(object));
        } else if (object != null) {
            jsonGenerator.writeString(this.mDateFormat.get().format(object));
        } else {
            if (fieldName != null) {
                jsonGenerator.writeFieldName(fieldName);
            }
            jsonGenerator.writeNull();
        }
    }

    public abstract DateFormat getDateFormat();
}

