/*
 * Decompiled with CFR 0.152.
 */
package com.bluetrainsoftware.common.config;

import com.bluetrainsoftware.common.config.BatheTimeWatcher;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.stickycode.configured.ConfigurationSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MapPropertySource;

public class BaseConfigurationFileWatcher {
    private static final Logger log = LoggerFactory.getLogger(BatheTimeWatcher.class);
    protected static Set<File> watchedFiles = new HashSet<File>();
    protected static Map<File, Long> lastModified = new HashMap<File, Long>();
    protected static boolean requiresReloading = false;
    protected static int watchTimeout = 15;
    @Inject
    public ConfigurationSystem system;

    public void startWatching() {
        if (this.system != null && watchedFiles.size() > 0 && watchTimeout > 0) {
            new Thread(() -> {
                while (true) {
                    try {
                        Thread.sleep(watchTimeout * 1000);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    this.loadWatchedFiles();
                    if (!requiresReloading) continue;
                    this.system.start();
                }
            }).start();
        }
    }

    protected boolean isYaml(File f) {
        String name = f.getName().toLowerCase();
        return name.endsWith(".yml") || name.endsWith(".yaml");
    }

    protected boolean isProperties(File f) {
        String name = f.getName().toLowerCase();
        return name.endsWith(".properties");
    }

    protected void loadWatchedFiles() {
        requiresReloading = false;
        Set newWatchedFiles = watchedFiles.stream().map(propertyFile -> {
            File newFile = new File(propertyFile.getAbsolutePath());
            Long previousLastModifiedTime = lastModified.get(propertyFile);
            if (newFile.exists() && (previousLastModifiedTime == null || newFile.lastModified() != previousLastModifiedTime.longValue())) {
                log.info("Loading configuration `{}` into system properties", (Object)newFile.getAbsolutePath());
                MapPropertySource propertySource = this.loadPropertyFile(newFile);
                lastModified.remove(propertyFile);
                if (propertySource == null) {
                    return null;
                }
                lastModified.put(newFile, newFile.lastModified());
                ((Map)propertySource.getSource()).forEach((key, value) -> System.setProperty(key, value.toString()));
                requiresReloading = true;
                return newFile;
            }
            return propertyFile;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        watchedFiles = newWatchedFiles;
        this.checkForTimerOverride();
    }

    protected MapPropertySource loadPropertyFile(File propertyFile) {
        return null;
    }

    protected void checkForTimerOverride() {
        String timeout = System.getProperty("sticky.timeout");
        if (timeout != null) {
            try {
                watchTimeout = Integer.parseInt(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

