/*
 * Decompiled with CFR 0.152.
 */
package com.bluetrainsoftware.common.config;

import bathe.BatheInitializer;
import com.bluetrainsoftware.common.config.BaseConfigurationFileWatcher;
import com.bluetrainsoftware.common.config.PreStart;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.parser.ParserException;

public class BatheTimeWatcher
extends BaseConfigurationFileWatcher
implements BatheInitializer {
    private static final Logger log = LoggerFactory.getLogger(BatheTimeWatcher.class);
    private static final String MINUS_D = "-D";
    private static final String MINUS_P = "-P";

    @PreStart
    public void start() {
        this.startWatching();
    }

    public int getOrder() {
        return -1;
    }

    public String getName() {
        return "bathe-system-property";
    }

    public String[] initialize(String[] args, String jumpClass) {
        ArrayList<String> appArguments = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith(MINUS_D)) {
                String property = arg.substring(MINUS_D.length());
                int equals = property.indexOf(61);
                if (equals >= 0) {
                    System.setProperty(property.substring(0, equals), property.substring(equals + 1));
                    continue;
                }
                System.setProperty(property, Boolean.TRUE.toString());
                continue;
            }
            if (arg.startsWith(MINUS_P)) {
                try {
                    this.loadProperties(arg.substring(MINUS_P.length()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            appArguments.add(arg);
        }
        return appArguments.toArray(new String[0]);
    }

    private boolean isWindows() {
        return ";".equals(File.pathSeparator);
    }

    private void loadProperties(String originalUrl) throws IOException {
        DuplicateProperties loadingProperties = new DuplicateProperties();
        String url = this.decodeUrl(originalUrl);
        if (url.startsWith("classpath:")) {
            this.singleLoadClasspath(url, loadingProperties);
        } else if (url.contains(":") && (!this.isWindows() || url.indexOf(58) > 1)) {
            this.singleLoadUrl(url, loadingProperties);
        } else {
            File properties = new File(url);
            if (properties.exists() && (this.isYaml(properties) || this.isProperties(properties))) {
                watchedFiles.add(properties);
            }
        }
        System.getProperties().putAll((Map<?, ?>)loadingProperties);
        if (watchedFiles.size() > 0) {
            this.loadWatchedFiles();
        }
    }

    protected String decodeUrl(String url) {
        int idx = url.indexOf("${");
        while (idx > -1) {
            String part1 = url.substring(0, idx);
            String part2 = url.substring(idx + 2);
            int idx2 = part2.indexOf("}");
            if (idx2 == -1) {
                url = part1 + "\\$\\{" + part2;
            } else {
                String part3 = part2.substring(idx2 + 1);
                url = part1 + System.getProperty(part2.substring(0, idx2), "") + part3;
            }
            idx = url.indexOf("${");
        }
        return url.replace("\\$\\{", "${");
    }

    private void singleLoadUrl(String url, Properties loadingProperties) throws IOException {
        URL source = new URL(url);
        InputStream is = source.openStream();
        loadingProperties.load(is);
        is.close();
    }

    private void singleLoadClasspath(String url, Properties loadingProperties) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(url.substring(10));
        if (is == null) {
            System.err.println("Failed to load ${url}  (${url.substring(10)})");
        } else {
            loadingProperties.load(is);
            is.close();
        }
    }

    @Override
    protected MapPropertySource loadPropertyFile(File propertyFile) {
        if (this.isYaml(propertyFile)) {
            return this.loadYamlFile(propertyFile);
        }
        return this.loadPropertyFileContents(propertyFile);
    }

    protected MapPropertySource loadYamlFile(File yamlFile) {
        Yaml parser = new Yaml((BaseConstructor)new StrictMapAppenderConstructor());
        try {
            Map yamlProperties = (Map)parser.load((Reader)new FileReader(yamlFile));
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.buildFlattenedMap(result, yamlProperties, null);
            return new MapPropertySource(yamlFile.getAbsolutePath(), result);
        }
        catch (FileNotFoundException e) {
            System.out.println("Unable to find file " + yamlFile.getAbsolutePath());
            return null;
        }
    }

    private void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (StringUtils.hasText((String)path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                boolean allSimple = collection.stream().allMatch(o -> o != null && o.getClass().getName().startsWith("java.lang."));
                if (allSimple) {
                    result.put(key, collection.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(",")));
                    continue;
                }
                int count = 0;
                for (Object object : collection) {
                    this.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value : "");
        }
    }

    private MapPropertySource loadPropertyFileContents(File propertyFile) {
        DuplicateProperties properties = new DuplicateProperties();
        try {
            properties.load(new FileReader(propertyFile));
        }
        catch (IOException e) {
            log.error("Unable to load file {}", (Object)propertyFile.getAbsolutePath());
            return null;
        }
        HashMap map = new HashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(key.toString(), value)));
        return new MapPropertySource(propertyFile.getName(), map);
    }

    protected static final class DuplicateProperties
    extends Properties {
        protected DuplicateProperties() {
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            Object previous = super.put(key, value);
            if (previous != null) {
                throw new IllegalStateException(String.format("Key '%s' has duplicate values as %s and %s", key, previous.toString(), value.toString()));
            }
            return null;
        }
    }

    protected static class StrictMapAppenderConstructor
    extends Constructor {
        protected Map<Object, Object> constructMapping(MappingNode node) {
            try {
                return super.constructMapping(node);
            }
            catch (IllegalStateException ex) {
                throw new ParserException("while parsing MappingNode", node.getStartMark(), ex.getMessage(), node.getEndMark());
            }
        }

        protected Map<Object, Object> createDefaultMap() {
            final Map delegate = super.createDefaultMap();
            return new AbstractMap<Object, Object>(){

                @Override
                public Object put(Object key, Object value) {
                    if (delegate.containsKey(key)) {
                        throw new IllegalStateException("Duplicate key: " + key);
                    }
                    return delegate.put(key, value);
                }

                @Override
                public Set<Map.Entry<Object, Object>> entrySet() {
                    return delegate.entrySet();
                }
            };
        }
    }
}

