/*
 * Decompiled with CFR 0.152.
 */
package com.bluetrainsoftware.common.config;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import net.stickycode.configured.Configuration;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.configured.ConfiguredConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentConfigurationListener
extends ConfiguredConfigurationListener {
    protected static final Logger log = LoggerFactory.getLogger(ConcurrentConfigurationListener.class);
    @Inject
    private ConfigurationRepository localConfigurations;
    private final Executor executor = Executors.newCachedThreadPool(new Factory());

    public void postConfigure() {
        ArrayList futures = new ArrayList();
        this.localConfigurations.forEach(config -> {
            Runnable asyncActivity = new Runnable((Configuration)config){
                final /* synthetic */ Configuration val$config;
                {
                    this.val$config = configuration;
                }

                @Override
                public void run() {
                    this.val$config.postConfigure();
                }
            };
            futures.add(CompletableFuture.runAsync(asyncActivity, this.executor));
        });
        CompletableFuture[] asyncs = new CompletableFuture[futures.size()];
        CompletableFuture.allOf(futures.toArray(asyncs)).join();
    }

    private static class Factory
    implements ThreadFactory {
        private final AtomicInteger count = new AtomicInteger();

        private Factory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("stickyconfig-async-#" + this.count.getAndIncrement());
            thread.setUncaughtExceptionHandler((t, e) -> LoggerFactory.getLogger((String)t.getName()).error(e.getMessage(), e));
            log.debug("created new thread for async handling {}", (Object)thread.getName());
            return thread;
        }
    }
}

