/*
 * Decompiled with CFR 0.152.
 */
package com.bluetrainsoftware.common.config;

import com.bluetrainsoftware.common.config.ConfigKey;
import com.bluetrainsoftware.common.config.ConfigKeyProcessor;
import com.bluetrainsoftware.common.config.PreStart;
import com.bluetrainsoftware.common.config.PreStartRepository;
import java.lang.reflect.Method;
import javax.inject.Inject;
import net.stickycode.configured.ConfigurationAttribute;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.configured.ForMethodOnlyBeansDummyAttribute;
import net.stickycode.metadata.MetadataResolverRegistry;
import net.stickycode.reflector.AnnotatedMethodProcessor;
import net.stickycode.reflector.FieldProcessor;
import net.stickycode.reflector.MethodProcessor;
import net.stickycode.reflector.Reflector;
import net.stickycode.stereotype.configured.PostConfigured;
import net.stickycode.stereotype.configured.PreConfigured;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

public class ConfigKeyPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    @Inject
    MetadataResolverRegistry metdataResolverRegistry;
    @Inject
    private ConfigurationRepository configurationRepository;
    @Inject
    protected PreStartRepository preStartRepository;

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        if (this.typeIsConfigured(bean.getClass())) {
            this.configurationRepository.register((ConfigurationAttribute)new ForMethodOnlyBeansDummyAttribute(bean));
            new Reflector().forEachField(new FieldProcessor[]{new ConfigKeyProcessor(this.configurationRepository)}).process(bean);
            new Reflector().forEachMethod(new MethodProcessor[]{new AnnotatedMethodProcessor(new Class[]{PreStart.class}){

                public void processMethod(Object target, Method method) {
                    ConfigKeyPostProcessor.this.preStartRepository.registerPreStart(target, method);
                }
            }}).process(bean);
        }
        return true;
    }

    private boolean typeIsConfigured(Class<?> type) {
        if (this.metdataResolverRegistry.does(type).haveAnyFieldsMetaAnnotatedWith(new Class[]{ConfigKey.class})) {
            return true;
        }
        return this.metdataResolverRegistry.does(type).haveAnyMethodsMetaAnnotatedWith(new Class[]{PreConfigured.class, PostConfigured.class, PreStart.class});
    }
}

