/*
 * Decompiled with CFR 0.152.
 */
package com.bluetrainsoftware.common.config;

import com.bluetrainsoftware.common.config.PreStartRepository;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreStartRefresher
implements PreStartRepository {
    private static final Logger log = LoggerFactory.getLogger(PreStartRefresher.class);
    private final List<PreStartCallback> beans = new ArrayList<PreStartCallback>();

    @Override
    public void registerPreStart(Object o, Method m) {
        this.beans.add(new PreStartCallback(o, m));
    }

    @Override
    public void start() {
        this.beans.forEach(psc -> {
            try {
                psc.getMethod().invoke(psc.getObject(), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.info("Failed to invoke method `{}` on `{}`", (Object)psc.getMethod().getName(), (Object)psc.getObject().getClass().getName());
            }
        });
        this.beans.clear();
    }

    private class PreStartCallback {
        private final Object object;
        private final Method method;

        public PreStartCallback(Object object, Method method) {
            this.object = object;
            this.method = method;
        }

        public Object getObject() {
            return this.object;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

