/*
 * Decompiled with CFR 0.152.
 */
package com.bluetrainsoftware.common.config;

import net.stickycode.configuration.ConfigurationKey;
import net.stickycode.configuration.ConfigurationSource;
import net.stickycode.configuration.ConfigurationValue;
import net.stickycode.configuration.ResolvedConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertiesConfigurationSource
implements ConfigurationSource {
    private static final Logger log = LoggerFactory.getLogger(SystemPropertiesConfigurationSource.class);

    public SystemPropertiesConfigurationSource() {
        log.info("Sticky Configuration is ready to read from System Properties.");
    }

    public void apply(ConfigurationKey configurationKey, ResolvedConfiguration resolvedConfiguration) {
        final String key = (String)configurationKey.join(".").get(0);
        final String value = System.getProperty(key);
        if (value != null) {
            resolvedConfiguration.add(new ConfigurationValue(){

                public String get() {
                    String newValue = System.getProperty(key);
                    return newValue == null ? value : newValue;
                }

                public boolean hasPrecedence(ConfigurationValue v) {
                    return false;
                }
            });
        }
    }
}

