/*
 * Decompiled with CFR 0.152.
 */
package com.bluetrainsoftware.common.config;

import com.bluetrainsoftware.common.config.BaseConfigurationFileWatcher;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.stickycode.configured.ConfigurationSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class WatchedFilesApplicationRunListener
extends BaseConfigurationFileWatcher
implements SpringApplicationRunListener {
    private static final Logger log = LoggerFactory.getLogger(WatchedFilesApplicationRunListener.class);
    protected ConfigurationSystem system;
    protected YamlPropertySourceLoader yamlPropertySourceLoader = new YamlPropertySourceLoader();
    protected PropertiesPropertySourceLoader propertiesPropertySourceLoader = new PropertiesPropertySourceLoader();

    public WatchedFilesApplicationRunListener(SpringApplication application, String[] args) {
        this.determineWatchedFileListFromCommandLineArguments(args);
    }

    protected void determineWatchedFileListFromCommandLineArguments(String[] args) {
        Arrays.stream(args).forEach(arg -> {
            if (arg.startsWith("-P")) {
                File props = new File(arg.substring(2));
                if (props.exists() && props.canRead() && (props.getName().endsWith(".yml") || props.getName().endsWith(".properties"))) {
                    watchedFiles.add(props);
                } else {
                    log.error("Requested property file `{}` to be loaded but does not exist, cannot read or not yaml or properties.", (Object)props.getAbsolutePath());
                }
            }
        });
    }

    @Override
    protected MapPropertySource loadPropertyFile(File newFile) {
        return this.loadPropertyFile((PropertySourceLoader)(this.isYaml(newFile) ? this.yamlPropertySourceLoader : this.propertiesPropertySourceLoader), newFile);
    }

    private MapPropertySource loadPropertyFile(PropertySourceLoader loader, File newFile) {
        try {
            return (MapPropertySource)MapPropertySource.class.cast(loader.load(newFile.getName(), (Resource)new FileSystemResource(newFile), null));
        }
        catch (IOException e) {
            log.error("Unable to load `{}`", (Object)newFile.getAbsolutePath());
            return null;
        }
    }

    public void started() {
    }

    public void starting() {
    }

    public void environmentPrepared(ConfigurableEnvironment configurableEnvironment) {
        this.loadWatchedFiles();
    }

    public void contextPrepared(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public void contextLoaded(ConfigurableApplicationContext configurableApplicationContext) {
    }

    public void finished(ConfigurableApplicationContext configurableApplicationContext, Throwable throwable) {
        this.system = (ConfigurationSystem)configurableApplicationContext.getBean(ConfigurationSystem.class);
        this.startWatching();
    }
}

