/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.bmuschko.gradle.docker.shaded.javax.ws.rs.client.Entity;
import com.bmuschko.gradle.docker.shaded.javax.ws.rs.client.Invocation;
import com.bmuschko.gradle.docker.shaded.javax.ws.rs.core.Response;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.async.FrameStreamProcessor;
import com.github.dockerjava.core.async.JsonStreamProcessor;
import com.github.dockerjava.jaxrs.async.GETCallbackNotifier;
import com.github.dockerjava.jaxrs.async.POSTCallbackNotifier;
import com.github.dockerjava.jaxrs.util.WrappedResponseInputStream;
import java.io.IOException;
import java.io.InputStream;

class JerseyInvocationBuilder
implements InvocationBuilder {
    private final ObjectMapper objectMapper;
    private final Invocation.Builder resource;

    JerseyInvocationBuilder(ObjectMapper objectMapper, Invocation.Builder resource) {
        this.objectMapper = objectMapper;
        this.resource = resource;
    }

    @Override
    public InvocationBuilder accept(MediaType mediaType) {
        this.resource.accept(mediaType.getMediaType());
        return this;
    }

    @Override
    public InvocationBuilder header(String name, String value) {
        this.resource.header(name, value);
        return this;
    }

    @Override
    public void delete() {
        this.resource.delete().close();
    }

    @Override
    public void get(ResultCallback<Frame> resultCallback) {
        try {
            GETCallbackNotifier<Frame> getCallbackNotifier = new GETCallbackNotifier<Frame>(new FrameStreamProcessor(), resultCallback, this.resource);
            getCallbackNotifier.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T get(TypeReference<T> typeReference) {
        try (Response response = this.resource.get();){
            Object t = this.objectMapper.readValue(response.readEntity(InputStream.class), typeReference);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        try {
            GETCallbackNotifier<T> getCallbackNotifier = new GETCallbackNotifier<T>(new JsonStreamProcessor<T>(this.objectMapper, typeReference), resultCallback, this.resource);
            getCallbackNotifier.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream post(Object entity) {
        return new WrappedResponseInputStream(this.resource.post(JerseyInvocationBuilder.toEntity(entity, "application/json")));
    }

    @Override
    public void post(Object entity, InputStream stdin, ResultCallback<Frame> resultCallback) {
        if (stdin != null) {
            throw new UnsupportedOperationException("Passing stdin to the container is currently not supported.");
        }
        POSTCallbackNotifier<Frame> postCallbackNotifier = new POSTCallbackNotifier<Frame>(new FrameStreamProcessor(), resultCallback, this.resource, JerseyInvocationBuilder.toEntity(entity, "application/json"));
        postCallbackNotifier.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T post(Object entity, TypeReference<T> typeReference) {
        Response response = this.resource.post(JerseyInvocationBuilder.toEntity(entity, "application/json"));
        if (response.getStatus() == 401) {
            throw new UnauthorizedException("Unauthorized");
        }
        try (InputStream inputStream = response.readEntity(InputStream.class);){
            Object t = this.objectMapper.readValue(inputStream, typeReference);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        try {
            POSTCallbackNotifier<T> postCallbackNotifier = new POSTCallbackNotifier<T>(new JsonStreamProcessor<T>(this.objectMapper, typeReference), resultCallback, this.resource, JerseyInvocationBuilder.toEntity(entity, "application/json"));
            postCallbackNotifier.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        try (Response response = this.resource.post(JerseyInvocationBuilder.toEntity(body, "application/octet-stream"));){
            InputStream inputStream = response.readEntity(InputStream.class);
            Object t = this.objectMapper.readValue(inputStream, typeReference);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        try {
            POSTCallbackNotifier<T> postCallbackNotifier = new POSTCallbackNotifier<T>(new JsonStreamProcessor<T>(this.objectMapper, typeReference), resultCallback, this.resource, JerseyInvocationBuilder.toEntity(body, "application/tar"));
            postCallbackNotifier.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void postStream(InputStream body) {
        this.resource.post(JerseyInvocationBuilder.toEntity(body, "application/octet-stream")).close();
    }

    @Override
    public InputStream get() {
        return new WrappedResponseInputStream(this.resource.get());
    }

    @Override
    public void put(InputStream body, MediaType mediaType) {
        this.resource.put(JerseyInvocationBuilder.toEntity(body, mediaType.getMediaType())).close();
    }

    private static <T> Entity<T> toEntity(T entity, String mediaType) {
        if (entity == null) {
            return null;
        }
        return Entity.entity(entity, mediaType);
    }
}

