/*
 * Decompiled with CFR 0.152.
 */
package com.asyncmd.starter;

import com.asyncmd.callback.AbstractErrorCallBack;
import com.asyncmd.config.AsynGroupConfig;
import com.asyncmd.starter.ParamUtil;
import com.asyncmd.starter.properties.AsynBackupJobProperties;
import com.asyncmd.starter.properties.AsynCoreProperties;
import com.asyncmd.starter.properties.AsynExecuterJobProperties;
import com.asyncmd.starter.properties.AsynPollProperties;
import com.asyncmd.starter.properties.AsynRestjobProperties;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;

@Configuration
@EnableConfigurationProperties(value={AsynCoreProperties.class, AsynExecuterJobProperties.class, AsynRestjobProperties.class, AsynBackupJobProperties.class, AsynPollProperties.class})
@ConditionalOnClass(value={AsynGroupConfig.class})
@ConditionalOnProperty(prefix="asyn", value={"enabled"}, matchIfMissing=true)
@ImportResource(locations={"classpath*:META-INF/asyn/applicationContext.xml"})
public class AsynServiceAutoConfiguration {
    @Autowired
    private AsynCoreProperties asynCoreProperties;
    @Autowired
    private AsynExecuterJobProperties asynExecuterJobProperties;
    @Autowired
    private AsynRestjobProperties asynRestjobProperties;
    @Autowired
    private AsynBackupJobProperties asynBackupJobProperties;
    @Autowired
    private AsynPollProperties asynPollProperties;
    @Resource(name="groupErrorCallBack")
    private AbstractErrorCallBack abstractErrorCallBack;

    @Bean
    @ConditionalOnMissingBean(value={AsynGroupConfig.class})
    public AsynGroupConfig helloServiceConfiguration(DataSource dataSource) {
        AsynGroupConfig asynGroupConfig = new AsynGroupConfig();
        ParamUtil.assertStringNull(this.asynCoreProperties.getJobName(), "\u5f02\u6b65\u547d\u4ee4\u7ec4\u4ef6jobName\u4e0d\u80fd\u4e3a\u7a7a");
        asynGroupConfig.setJobName(this.asynCoreProperties.getJobName());
        ParamUtil.assertStringNull(this.asynCoreProperties.getEnv(), "\u5f02\u6b65\u547d\u4ee4\u7ec4\u4ef6env\u4e0d\u80fd\u4e3a\u7a7a");
        asynGroupConfig.setEnv(this.asynCoreProperties.getEnv());
        ParamUtil.assertStringNull(this.asynCoreProperties.getZookeeperUrl(), "\u5f02\u6b65\u547d\u4ee4\u7ec4\u4ef6zookeeper\u4e0d\u80fd\u4e3a\u7a7a");
        asynGroupConfig.setZookeeperUrl(this.asynCoreProperties.getZookeeperUrl());
        asynGroupConfig.setDataSource(dataSource);
        if (ParamUtil.isNotNull(this.asynCoreProperties.getTableNum()).booleanValue()) {
            asynGroupConfig.setTableNum(this.asynCoreProperties.getTableNum().intValue());
        }
        if (ParamUtil.isNotEmpty(this.asynCoreProperties.getExecuterFrequencys()).booleanValue()) {
            asynGroupConfig.setExecuterFrequencys(this.asynCoreProperties.getExecuterFrequencys());
        }
        if (ParamUtil.isNotEmpty(this.asynExecuterJobProperties.getCron()).booleanValue()) {
            asynGroupConfig.setCron(this.asynExecuterJobProperties.getCron());
        }
        if (ParamUtil.isNotNull(this.asynExecuterJobProperties.getLimit()).booleanValue()) {
            asynGroupConfig.setLimit(this.asynExecuterJobProperties.getLimit().intValue());
        }
        if (ParamUtil.isNotNull(this.asynExecuterJobProperties.getDesc()).booleanValue()) {
            asynGroupConfig.setDesc(this.asynExecuterJobProperties.getDesc());
        }
        if (ParamUtil.isNotNull(this.asynExecuterJobProperties.getRetryNum()).booleanValue()) {
            asynGroupConfig.setRetryNum(this.asynExecuterJobProperties.getRetryNum().intValue());
        }
        if (ParamUtil.isNotNull(this.asynPollProperties.getCorePoolSize()).booleanValue()) {
            asynGroupConfig.setCorePoolSize(this.asynPollProperties.getCorePoolSize().intValue());
        }
        if (ParamUtil.isNotNull(this.asynPollProperties.getMaxPoolSize()).booleanValue()) {
            asynGroupConfig.setMaxPoolSize(this.asynPollProperties.getMaxPoolSize().intValue());
        }
        if (ParamUtil.isNotNull(this.asynPollProperties.getQueueCapacity()).booleanValue()) {
            asynGroupConfig.setQueueCapacity(this.asynPollProperties.getQueueCapacity().intValue());
        }
        if (ParamUtil.isNotEmpty(this.asynRestjobProperties.getRestCron()).booleanValue()) {
            asynGroupConfig.setRestCron(this.asynRestjobProperties.getRestCron());
        }
        if (ParamUtil.isNotNull(this.asynBackupJobProperties.getBackup()).booleanValue()) {
            asynGroupConfig.setBackup(this.asynBackupJobProperties.getBackup());
        }
        if (ParamUtil.isNotEmpty(this.asynBackupJobProperties.getBackupCron()).booleanValue()) {
            asynGroupConfig.setBackupCron(this.asynBackupJobProperties.getBackupCron());
        }
        if (ParamUtil.isNotNull(this.asynBackupJobProperties.getBeforeDate()).booleanValue()) {
            asynGroupConfig.setBeforeDate(this.asynBackupJobProperties.getBeforeDate());
        }
        if (ParamUtil.isNotNull(this.asynBackupJobProperties.getMaxNo()).booleanValue()) {
            asynGroupConfig.setMaxNo(this.asynBackupJobProperties.getMaxNo());
        }
        if (ParamUtil.isNotNull(this.abstractErrorCallBack).booleanValue()) {
            asynGroupConfig.setAbstractErrorCallBack(this.abstractErrorCallBack);
        }
        return asynGroupConfig;
    }
}

