/*
 * Decompiled with CFR 0.152.
 */
package com.bol.ipresource.etree;

import com.bol.ipresource.etree.ChildNodeMap;
import com.bol.ipresource.etree.InternalNode;
import com.bol.ipresource.etree.IntersectingIntervalException;
import com.bol.ipresource.ip.Interval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class ChildNodeTreeMap<K extends Interval<K>, V>
extends TreeMap<K, InternalNode<K, V>>
implements ChildNodeMap<K, V> {
    private static final long serialVersionUID = 1L;
    static final ChildNodeMap EMPTY = new Empty();
    private static final Comparator<Interval> UPPER_BOUND_COMPARATOR = new Comparator<Interval>(){

        @Override
        public int compare(Interval o1, Interval o2) {
            return o1.compareUpperBound(o2);
        }
    };

    static <K extends Interval<K>, T> ChildNodeMap<K, T> empty() {
        return EMPTY;
    }

    ChildNodeTreeMap() {
        super(UPPER_BOUND_COMPARATOR);
    }

    public ChildNodeTreeMap(ChildNodeMap<K, V> source) {
        this();
        for (InternalNode<K, V> node : source.values()) {
            this.put(node.getInterval(), new InternalNode<K, V>(node));
        }
    }

    @Override
    public V addChild(InternalNode<K, V> nodeToAdd) {
        K range = nodeToAdd.getInterval();
        InternalNode<K, V> containingChild = this.getChildContaining(range);
        if (containingChild != null) {
            return containingChild.addChild(nodeToAdd);
        }
        List<K> intersections = this.getIntersectingChildren(range);
        if (!intersections.isEmpty()) {
            throw new IntersectingIntervalException((Interval<?>)range, (List<? extends Interval<?>>)intersections);
        }
        this.transferChildNodes(nodeToAdd);
        InternalNode<K, V> previousValue = this.put(range, nodeToAdd);
        if (previousValue != null) {
            return previousValue.getValue();
        }
        return null;
    }

    private void transferChildNodes(InternalNode<K, V> nodeToAdd) {
        InternalNode child;
        Object range = nodeToAdd.getInterval();
        Iterator it = this.tailMap(range.singletonIntervalAtLowerBound()).values().iterator();
        while (it.hasNext() && range.contains((child = (InternalNode)it.next()).getInterval())) {
            nodeToAdd.addChild(child);
            it.remove();
        }
    }

    @Override
    public V removeChild(K interval) {
        InternalNode<K, V> containing = this.getChildContaining(interval);
        if (containing == null) {
            return null;
        }
        if (interval.equals(containing.getInterval())) {
            InternalNode removed = (InternalNode)this.remove(interval);
            for (InternalNode<K, V> node : containing.getChildren().values()) {
                this.put(node.getInterval(), node);
            }
            if (removed != null) {
                return removed.getValue();
            }
            return null;
        }
        return containing.removeChild(interval);
    }

    private List<K> getIntersectingChildren(K range) {
        Interval upperCandidate;
        List result = Collections.emptyList();
        Interval lowerCandidate = (Interval)this.ceilingKey(range.singletonIntervalAtLowerBound());
        if (lowerCandidate != null && this.intersectsButNotContained(range, lowerCandidate)) {
            result = new ArrayList(result);
            result.add(lowerCandidate);
        }
        if ((upperCandidate = (Interval)this.ceilingKey(range)) != null && this.intersectsButNotContained(range, upperCandidate)) {
            result = new ArrayList(result);
            result.add(upperCandidate);
        }
        return result;
    }

    private boolean intersectsButNotContained(K left, K right) {
        return left.intersects(right) && !left.contains(right) && !right.contains(left);
    }

    private InternalNode<K, V> getChildContaining(K range) {
        Map.Entry entry = this.ceilingEntry(range.singletonIntervalAtLowerBound());
        if (entry != null && ((Interval)entry.getKey()).contains(range)) {
            return (InternalNode)entry.getValue();
        }
        return null;
    }

    @Override
    public void findExactAndAllLessSpecific(List<InternalNode<K, V>> result, K range) {
        InternalNode<K, V> node = this.getChildContaining(range);
        if (node != null) {
            result.add(node);
            node.getChildren().findExactAndAllLessSpecific(result, range);
        }
    }

    @Override
    public void findExactAndAllMoreSpecific(List<InternalNode<K, V>> result, K range) {
        for (InternalNode node : this.tailMap(range.singletonIntervalAtLowerBound()).values()) {
            if (range.contains(node.getInterval())) {
                result.add(node);
                node.getChildren().addAllChildrenToList(result);
                continue;
            }
            if (!range.intersects(node.getInterval())) break;
            node.getChildren().findExactAndAllMoreSpecific(result, range);
        }
    }

    @Override
    public void findFirstMoreSpecific(List<InternalNode<K, V>> result, K range) {
        for (InternalNode node : this.tailMap(range.singletonIntervalAtLowerBound()).values()) {
            if (range.contains(node.getInterval())) {
                result.add(node);
                continue;
            }
            if (!range.intersects(node.getInterval())) break;
            node.getChildren().findFirstMoreSpecific(result, range);
        }
    }

    @Override
    public void addAllChildrenToList(List<InternalNode<K, V>> list) {
        for (InternalNode node : this.values()) {
            list.add(node);
            node.getChildren().addAllChildrenToList(list);
        }
    }

    private static final class Empty
    extends TreeMap
    implements ChildNodeMap {
        private static final long serialVersionUID = 1L;

        private Empty() {
        }

        public Object addChild(InternalNode childToAdd) {
            throw new UnsupportedOperationException();
        }

        public Object removeChild(Interval interval) {
            throw new UnsupportedOperationException();
        }

        public void findExactAndAllLessSpecific(List list, Interval range) {
        }

        public void findExactAndAllMoreSpecific(List list, Interval range) {
        }

        public void findFirstMoreSpecific(List list, Interval interval) {
        }

        public void addAllChildrenToList(List list) {
        }
    }
}

