/*
 * Decompiled with CFR 0.152.
 */
package com.bol.ipresource.etree;

import com.bol.ipresource.etree.ChildNodeMap;
import com.bol.ipresource.etree.ChildNodeTreeMap;
import com.bol.ipresource.ip.Interval;
import com.bol.ipresource.util.Validate;

final class InternalNode<K extends Interval<K>, V> {
    private final K interval;
    private V value;
    private ChildNodeMap<K, V> children = ChildNodeTreeMap.empty();

    public InternalNode(K interval, V value) {
        Validate.notNull(interval, "interval");
        Validate.notNull(value, "value");
        this.interval = interval;
        this.value = value;
    }

    public InternalNode(InternalNode<K, V> source) {
        this.interval = source.interval;
        this.value = source.value;
        this.children = source.children == ChildNodeTreeMap.EMPTY ? ChildNodeTreeMap.empty() : new ChildNodeTreeMap<K, V>(source.children);
    }

    public K getInterval() {
        return this.interval;
    }

    public V getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternalNode that = (InternalNode)obj;
        return this.interval.equals(that.interval) && this.value.equals(that.value) && this.children.equals(that.children);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.interval.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.children.hashCode();
        return result;
    }

    public String toString() {
        return "Node(" + this.interval + ", " + this.value + ", " + this.children + ")";
    }

    ChildNodeMap<K, V> getChildren() {
        return this.children;
    }

    V addChild(InternalNode<K, V> nodeToAdd) {
        if (this.interval.equals(nodeToAdd.getInterval())) {
            V previousValue = this.value;
            this.value = nodeToAdd.getValue();
            return previousValue;
        }
        if (!this.interval.contains(nodeToAdd.getInterval())) {
            throw new IllegalArgumentException(nodeToAdd.getInterval() + " not properly contained in " + this.interval);
        }
        if (this.children == ChildNodeTreeMap.EMPTY) {
            this.children = new ChildNodeTreeMap();
        }
        return this.children.addChild(nodeToAdd);
    }

    public V removeChild(K range) {
        if (!this.interval.contains(range) || this.interval.equals(range)) {
            throw new IllegalArgumentException(range + " not properly contained in " + this.interval);
        }
        if (this.children != ChildNodeTreeMap.EMPTY) {
            V value = this.children.removeChild(range);
            if (this.children.isEmpty()) {
                this.children = ChildNodeTreeMap.empty();
            }
            return value;
        }
        return null;
    }
}

