/*
 * Decompiled with CFR 0.152.
 */
package com.bol.ipresource.etree;

import com.bol.ipresource.etree.IntervalMap;
import com.bol.ipresource.etree.NestedIntervalMap;
import com.bol.ipresource.ip.Interval;
import com.bol.ipresource.util.CollectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public final class MultiValueIntervalMap<K extends Interval<K>, V>
implements IntervalMap<K, V> {
    private final IntervalMap<K, SortedSet<V>> wrapped = new NestedIntervalMap<K, SortedSet<V>>();

    @Override
    public V put(K key, V value) {
        SortedSet<V> set = CollectionHelper.uniqueResult(this.wrapped.findExact(key));
        if (set == null) {
            set = new TreeSet<V>();
            this.wrapped.put(key, set);
        }
        set.add(value);
        return null;
    }

    @Override
    public V remove(K key) {
        this.wrapped.remove(key);
        return null;
    }

    @Override
    public void remove(K key, V value) {
        SortedSet<V> set = CollectionHelper.uniqueResult(this.wrapped.findExact(key));
        if (set == null) {
            return;
        }
        set.remove(value);
        if (set.isEmpty()) {
            this.wrapped.remove(key);
        }
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    private static <V> List<V> unroll(List<SortedSet<V>> sets) {
        int size = 0;
        for (SortedSet<V> set : sets) {
            size += set.size();
        }
        ArrayList<V> result = new ArrayList<V>(size);
        for (SortedSet<V> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    @Override
    public List<V> findFirstLessSpecific(K key) {
        return MultiValueIntervalMap.unroll(this.wrapped.findFirstLessSpecific(key));
    }

    @Override
    public List<V> findExact(K key) {
        return MultiValueIntervalMap.unroll(this.wrapped.findExact(key));
    }

    @Override
    public List<V> findExactOrFirstLessSpecific(K key) {
        return MultiValueIntervalMap.unroll(this.wrapped.findExactOrFirstLessSpecific(key));
    }

    @Override
    public List<V> findAllLessSpecific(K key) {
        return MultiValueIntervalMap.unroll(this.wrapped.findAllLessSpecific(key));
    }

    @Override
    public List<V> findExactAndAllLessSpecific(K key) {
        return MultiValueIntervalMap.unroll(this.wrapped.findExactAndAllLessSpecific(key));
    }

    @Override
    public List<V> findFirstMoreSpecific(K key) {
        return MultiValueIntervalMap.unroll(this.wrapped.findFirstMoreSpecific(key));
    }

    @Override
    public List<V> findAllMoreSpecific(K key) {
        return MultiValueIntervalMap.unroll(this.wrapped.findAllMoreSpecific(key));
    }

    @Override
    public List<V> findExactAndAllMoreSpecific(K key) {
        return MultiValueIntervalMap.unroll(this.wrapped.findExactAndAllMoreSpecific(key));
    }
}

