/*
 * Decompiled with CFR 0.152.
 */
package com.bol.ipresource.etree;

import com.bol.ipresource.etree.ChildNodeMap;
import com.bol.ipresource.etree.ChildNodeTreeMap;
import com.bol.ipresource.etree.InternalNode;
import com.bol.ipresource.etree.IntervalMap;
import com.bol.ipresource.ip.Interval;
import com.bol.ipresource.util.CollectionHelper;
import com.bol.ipresource.util.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class NestedIntervalMap<K extends Interval<K>, V>
implements IntervalMap<K, V> {
    private final ChildNodeMap<K, V> children;

    public NestedIntervalMap() {
        this.children = new ChildNodeTreeMap();
    }

    public NestedIntervalMap(NestedIntervalMap<K, V> source) {
        this.children = new ChildNodeTreeMap<K, V>(source.children);
    }

    @Override
    public V put(K key, V value) {
        Validate.notNull(key);
        Validate.notNull(value);
        return this.children.addChild(new InternalNode<K, V>(key, value));
    }

    @Override
    public V remove(K key) {
        Validate.notNull(key);
        return this.children.removeChild(key);
    }

    @Override
    public void remove(K key, V value) {
        Validate.notNull(key);
        Validate.notNull(value);
        if (value.equals(CollectionHelper.uniqueResult(this.findExact(key)))) {
            this.remove(key);
        }
    }

    @Override
    public List<V> findFirstLessSpecific(K key) {
        Validate.notNull(key);
        InternalNode<K, V> node = this.internalFindFirstLessSpecific(key);
        return this.mapToValues(node);
    }

    @Override
    public List<V> findAllLessSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindAllLessSpecific(key));
    }

    @Override
    public List<V> findExactAndAllLessSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindExactAndAllLessSpecific(key));
    }

    @Override
    public List<V> findExact(K key) {
        Validate.notNull(key);
        InternalNode<K, V> node = this.internalFindExact(key);
        return this.mapToValues(node);
    }

    @Override
    public List<V> findExactOrFirstLessSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindExactOrFirstLessSpecific(key));
    }

    @Override
    public List<V> findFirstMoreSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindFirstMoreSpecific(key));
    }

    @Override
    public List<V> findAllMoreSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindAllMoreSpecific(key));
    }

    @Override
    public List<V> findExactAndAllMoreSpecific(K key) {
        Validate.notNull(key);
        return this.mapToValues(this.internalFindExactAndAllMoreSpecific(key));
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.children.equals(((NestedIntervalMap)obj).children);
    }

    public int hashCode() {
        return this.children.hashCode();
    }

    public String toString() {
        return this.children.toString();
    }

    private List<V> mapToValues(InternalNode<K, V> node) {
        if (node == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(node.getValue());
    }

    private List<V> mapToValues(Collection<InternalNode<K, V>> nodes) {
        ArrayList<V> result = new ArrayList<V>(nodes.size() + 5);
        for (InternalNode<K, V> node : nodes) {
            result.add(node.getValue());
        }
        return result;
    }

    private InternalNode<K, V> internalFindExactOrFirstLessSpecific(K range) {
        List<InternalNode<K, V>> list = this.internalFindExactAndAllLessSpecific(range);
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private InternalNode<K, V> internalFindFirstLessSpecific(K range) {
        List<InternalNode<K, V>> list = this.internalFindAllLessSpecific(range);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    private List<InternalNode<K, V>> internalFindAllLessSpecific(K range) {
        List<InternalNode<K, V>> result = this.internalFindExactAndAllLessSpecific(range);
        if (result.isEmpty()) {
            return result;
        }
        InternalNode<K, V> last = result.get(result.size() - 1);
        if (last.getInterval().equals(range)) {
            return result.subList(0, result.size() - 1);
        }
        return result;
    }

    private List<InternalNode<K, V>> internalFindExactAndAllLessSpecific(K range) {
        ArrayList result = new ArrayList();
        this.children.findExactAndAllLessSpecific(result, range);
        return result;
    }

    private InternalNode<K, V> internalFindExact(K range) {
        List<InternalNode<K, V>> exactAndAllLessSpecific = this.internalFindExactAndAllLessSpecific(range);
        if (exactAndAllLessSpecific.isEmpty()) {
            return null;
        }
        InternalNode<K, V> last = exactAndAllLessSpecific.get(exactAndAllLessSpecific.size() - 1);
        if (last.getInterval().equals(range)) {
            return last;
        }
        return null;
    }

    private List<InternalNode<K, V>> internalFindFirstMoreSpecific(K range) {
        ArrayList result = new ArrayList();
        InternalNode<K, V> container = this.internalFindExactOrFirstLessSpecific(range);
        if (container == null) {
            this.children.findFirstMoreSpecific(result, range);
        } else {
            container.getChildren().findFirstMoreSpecific(result, range);
        }
        return result;
    }

    private List<InternalNode<K, V>> internalFindAllMoreSpecific(K range) {
        List<InternalNode<K, V>> result = this.internalFindExactAndAllMoreSpecific(range);
        if (!result.isEmpty() && result.get(0).getInterval().equals(range)) {
            return result.subList(1, result.size());
        }
        return result;
    }

    private List<InternalNode<K, V>> internalFindExactAndAllMoreSpecific(K range) {
        ArrayList result = new ArrayList();
        InternalNode<K, V> containing = this.internalFindExactOrFirstLessSpecific(range);
        if (containing == null) {
            this.children.findExactAndAllMoreSpecific(result, range);
        } else {
            if (containing.getInterval().equals(range)) {
                result.add(containing);
            }
            containing.getChildren().findExactAndAllMoreSpecific(result, range);
        }
        return result;
    }

    public static abstract class Key<K extends Interval<K>> {
        private final K key;

        public Key(K key) {
            Validate.notNull(key);
            this.key = key;
        }

        public K getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key that = (Key)obj;
            return this.key.equals(that.key);
        }

        public String toString() {
            return "IpResource(" + this.key + ")";
        }
    }
}

