/*
 * Decompiled with CFR 0.152.
 */
package com.bol.ipresource.etree;

import com.bol.ipresource.etree.IntervalMap;
import com.bol.ipresource.ip.Interval;
import java.util.List;

public final class SynchronizedIntervalMap<K extends Interval<K>, V>
implements IntervalMap<K, V> {
    private final Object mutex;
    private final IntervalMap<K, V> wrapped;

    public static <K extends Interval<K>, V> IntervalMap<K, V> synchronizedMap(IntervalMap<K, V> toWrap) {
        return new SynchronizedIntervalMap<K, V>(toWrap);
    }

    public static <K extends Interval<K>, V> IntervalMap<K, V> synchronizedMap(IntervalMap<K, V> toWrap, Object mutex) {
        return new SynchronizedIntervalMap<K, V>(toWrap, mutex);
    }

    private SynchronizedIntervalMap(IntervalMap<K, V> wrapped) {
        this.wrapped = wrapped;
        this.mutex = this;
    }

    private SynchronizedIntervalMap(IntervalMap<K, V> wrapped, Object mutex) {
        this.wrapped = wrapped;
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key, V value) {
        Object object = this.mutex;
        synchronized (object) {
            this.wrapped.remove(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> findFirstLessSpecific(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.findFirstLessSpecific(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> findAllLessSpecific(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.findAllLessSpecific(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> findExactAndAllLessSpecific(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.findExactAndAllLessSpecific(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> findExact(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.findExact(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> findExactOrFirstLessSpecific(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.findExactOrFirstLessSpecific(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> findFirstMoreSpecific(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.findFirstMoreSpecific(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> findAllMoreSpecific(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.findAllMoreSpecific(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> findExactAndAllMoreSpecific(K key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.wrapped.findExactAndAllMoreSpecific(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.wrapped.clear();
        }
    }
}

