/*
 * Decompiled with CFR 0.152.
 */
package com.bol.ipresource.ip;

import com.bol.ipresource.ip.Interval;
import com.bol.ipresource.ip.Ipv4Interval;
import com.bol.ipresource.ip.Ipv6Interval;
import com.bol.ipresource.util.Validate;
import java.net.Inet4Address;
import java.net.InetAddress;

public abstract class IpInterval<K>
implements Interval<K> {
    public static IpInterval<?> parse(String addressPrefixOrRange) {
        if (addressPrefixOrRange.indexOf(58) == -1) {
            return Ipv4Interval.parse(addressPrefixOrRange);
        }
        return Ipv6Interval.parse(addressPrefixOrRange);
    }

    public static IpInterval<?> valueOf(String addressPrefixOrRange) {
        return IpInterval.parse(addressPrefixOrRange);
    }

    public static IpInterval<?> parseIpAddress(String address) {
        if (address.indexOf(58) == -1) {
            return Ipv4Interval.parseIpAddress(address);
        }
        return Ipv6Interval.parseIpAddress(address);
    }

    public static IpInterval<?> parseReverseDomain(String reverse) {
        Validate.notEmpty(reverse);
        String cleanAddress = reverse.trim().toLowerCase();
        int reverseDomainIndex = Ipv4Interval.reverseDomainIndex(cleanAddress);
        if (reverseDomainIndex >= 0) {
            return Ipv4Interval.parseReverseDomain(cleanAddress, reverseDomainIndex);
        }
        reverseDomainIndex = Ipv6Interval.reverseDomainIndex(cleanAddress);
        if (reverseDomainIndex >= 0) {
            return Ipv6Interval.parseReverseDomain(cleanAddress, reverseDomainIndex);
        }
        throw new IllegalArgumentException("Invalid reverse domain: " + cleanAddress);
    }

    public static IpInterval<?> asIpInterval(InetAddress address) {
        if (address instanceof Inet4Address) {
            return Ipv4Interval.parse(address);
        }
        return Ipv6Interval.parse(address);
    }

    public abstract String toReverseDomain();

    public abstract String toRangeString();

    public abstract String toPrefixString();

    public abstract String beginAddressAsString();

    public abstract String endAddressAsString();

    public abstract InetAddress beginAsInetAddress();

    public abstract InetAddress endAsInetAddress();

    public abstract byte[] beginAsByteArray();

    public abstract byte[] endAsByteArray();

    public abstract int getPrefixLength();
}

