/*
 * Decompiled with CFR 0.152.
 */
package com.bol.ipresource.ip;

import com.bol.ipresource.ip.IpInterval;
import com.bol.ipresource.util.Validate;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class Ipv4Interval
extends IpInterval<Ipv4Interval>
implements Comparable<Ipv4Interval> {
    public static final String IPV4_DOTLESS_REVERSE_DOMAIN = ".in-addr.arpa";
    public static final String IPV4_REVERSE_DOMAIN = ".in-addr.arpa.";
    private static final Splitter IPV4_TEXT_SPLITTER = Splitter.on((char)'.');
    private static final long MINIMUM_NUMBER = 0L;
    private static final long MAXIMUM_NUMBER = 0xFFFFFFFFL;
    public static final Ipv4Interval MAX_RANGE = new Ipv4Interval(0L, 0xFFFFFFFFL);
    private static final Splitter SPLIT_ON_DOT = Splitter.on((char)'.');
    private static final Pattern OCTET_PATTERN = Pattern.compile("^(?:[0-9]|[1-9][0-9]+)(?:-(?:[0-9]|[1-9][0-9]+)+)?$");
    private final int begin;
    private final int end;

    private Ipv4Interval(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public Ipv4Interval(long begin, long end) {
        if (begin > end) {
            throw new IllegalArgumentException("Begin: " + begin + " not before End: " + end);
        }
        if (begin < 0L) {
            throw new IllegalArgumentException("Begin: " + begin + " out of range");
        }
        if (end > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("End: " + end + " out of range");
        }
        this.begin = (int)begin;
        this.end = (int)end;
    }

    public static Ipv4Interval parse(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("Not an IPv4 address: " + inetAddress);
        }
        byte[] addressArray = inetAddress.getAddress();
        int address = addressArray[3] & 0xFF;
        address |= addressArray[2] << 8 & 0xFF00;
        address |= addressArray[1] << 16 & 0xFF0000;
        return new Ipv4Interval(address |= addressArray[0] << 24 & 0xFF000000, address);
    }

    public static Ipv4Interval parse(String resource) {
        int indexOfSlash = resource.indexOf(47);
        if (indexOfSlash >= 0) {
            int begin = Ipv4Interval.textToNumericFormat(resource.substring(0, indexOfSlash).trim());
            int prefixLength = -1;
            try {
                prefixLength = Integer.parseInt(resource.substring(indexOfSlash + 1).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (prefixLength < 0 || prefixLength > 32) {
                throw new IllegalArgumentException("prefix length " + prefixLength + " is invalid");
            }
            int mask = (int)((1L << 32 - prefixLength) - 1L);
            int end = begin | mask;
            return new Ipv4Interval(begin &= ~mask, end);
        }
        int indexOfDash = resource.indexOf(45);
        if (indexOfDash >= 0) {
            long begin = (long)Ipv4Interval.textToNumericFormat(resource.substring(0, indexOfDash).trim()) & 0xFFFFFFFFL;
            long end = (long)Ipv4Interval.textToNumericFormat(resource.substring(indexOfDash + 1).trim()) & 0xFFFFFFFFL;
            return new Ipv4Interval(begin, end);
        }
        return Ipv4Interval.parseIpAddress(resource);
    }

    public static Ipv4Interval parseIpAddress(String ipAddress) {
        int begin = Ipv4Interval.textToNumericFormat(ipAddress.trim());
        return new Ipv4Interval(begin, begin);
    }

    public static Ipv4Interval parsePrefixWithLength(long prefix, int prefixLength) {
        long mask = (1L << 32 - prefixLength) - 1L;
        return new Ipv4Interval(prefix & (mask ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFL, (prefix | mask) & 0xFFFFFFFFL);
    }

    static int reverseDomainIndex(String cleanAddress) {
        int index = cleanAddress.length() - IPV4_REVERSE_DOMAIN.length();
        if (cleanAddress.startsWith(IPV4_REVERSE_DOMAIN, index)) {
            return index;
        }
        index = cleanAddress.length() - IPV4_DOTLESS_REVERSE_DOMAIN.length();
        if (cleanAddress.startsWith(IPV4_DOTLESS_REVERSE_DOMAIN, index)) {
            return index;
        }
        return -1;
    }

    public static Ipv4Interval parseReverseDomain(String address) {
        Validate.notEmpty(address);
        String cleanAddress = address.trim().toLowerCase();
        int reverseDomainIndex = Ipv4Interval.reverseDomainIndex(cleanAddress);
        Validate.isTrue(reverseDomainIndex >= 0, "Invalid reverse domain: ", address);
        return Ipv4Interval.parseReverseDomain(cleanAddress, reverseDomainIndex);
    }

    static Ipv4Interval parseReverseDomain(String cleanAddress, int reverseDomainIndex) {
        int range;
        ArrayList reverseParts = Lists.newArrayList((Iterable)SPLIT_ON_DOT.split((CharSequence)(cleanAddress = cleanAddress.substring(0, reverseDomainIndex))));
        Validate.isTrue(!reverseParts.isEmpty() && reverseParts.size() <= 4, "Reverse address doesn't have between 1 and 4 octets: ", cleanAddress);
        List parts = Lists.reverse((List)reverseParts);
        boolean hasDash = false;
        if (cleanAddress.contains("-")) {
            Validate.isTrue(((String)reverseParts.get(0)).contains("-"), "Dash notation not on last octet: ", cleanAddress);
            Validate.isTrue(cleanAddress.indexOf(45) == cleanAddress.lastIndexOf(45), "Only one dash allowed: ", cleanAddress);
            hasDash = true;
        }
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            Validate.isTrue(OCTET_PATTERN.matcher(part).matches(), "Invalid octet: ", part);
            builder.append(part);
        }
        if (hasDash && (range = builder.indexOf("-")) != -1) {
            builder.insert(range + 1, builder.substring(0, builder.lastIndexOf(".") + 1));
        }
        if (parts.size() < 4) {
            builder.append('/').append(parts.size() * 8);
        }
        return Ipv4Interval.parse(builder.toString());
    }

    public long begin() {
        return (long)this.begin & 0xFFFFFFFFL;
    }

    public long end() {
        return (long)this.end & 0xFFFFFFFFL;
    }

    @Override
    public boolean contains(Ipv4Interval that) {
        return this.begin() <= that.begin() && this.end() >= that.end();
    }

    @Override
    public boolean intersects(Ipv4Interval that) {
        return this.isIPWithinRange(this.begin(), that) || this.isIPWithinRange(this.end(), that) || this.isIPWithinRange(that.begin(), this);
    }

    private boolean isIPWithinRange(long ip, Ipv4Interval range) {
        return ip >= range.begin() && ip <= range.end();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.begin;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ipv4Interval that = (Ipv4Interval)obj;
        return this.begin == that.begin && this.end == that.end;
    }

    private static boolean isPowerOfTwo(int x) {
        return (x & x - 1) == 0;
    }

    public static String numericToTextFormat(int src) {
        return (src >> 24 & 0xFF) + "." + (src >> 16 & 0xFF) + "." + (src >> 8 & 0xFF) + "." + (src & 0xFF);
    }

    public static int textToNumericFormat(String src) {
        int result = 0;
        Iterator it = IPV4_TEXT_SPLITTER.split((CharSequence)src).iterator();
        for (int octet = 0; octet < 4; ++octet) {
            result <<= 8;
            int value = -1;
            try {
                value = it.hasNext() ? Integer.parseInt((String)it.next()) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value < 0 || value > 255) {
                throw new IllegalArgumentException(src + " is not a valid ipv4 address");
            }
            result |= value & 0xFF;
        }
        if (it.hasNext()) {
            throw new IllegalArgumentException(src + " has more than 4 octets");
        }
        return result;
    }

    public String toString() {
        int prefixLength = this.getPrefixLength();
        if (prefixLength < 0) {
            return this.toRangeString();
        }
        return Ipv4Interval.numericToTextFormat(this.begin) + "/" + prefixLength;
    }

    @Override
    public String toRangeString() {
        return Ipv4Interval.numericToTextFormat(this.begin) + " - " + Ipv4Interval.numericToTextFormat(this.end);
    }

    @Override
    public String toPrefixString() {
        int prefixLength = this.getPrefixLength();
        if (prefixLength < 0) {
            throw new IllegalStateException(this.toRangeString() + " cannot be converted to prefix");
        }
        return Ipv4Interval.numericToTextFormat(this.begin) + "/" + prefixLength;
    }

    @Override
    public String toReverseDomain() {
        int prefixLength = this.getPrefixLength();
        if (prefixLength < 0) {
            throw new IllegalArgumentException("Ipv4Interval " + this.toRangeString() + " is not a prefix");
        }
        byte[] b = Ints.toByteArray((int)this.begin);
        byte[] e = Ints.toByteArray((int)this.end);
        StringBuilder sb = new StringBuilder();
        for (int nibble = prefixLength - 1 >> 3; nibble >= 0; --nibble) {
            if (b[nibble] == e[nibble]) {
                sb.append(b[nibble] & 0xFF);
            } else {
                sb.append(b[nibble] & 0xFF).append('-').append(e[nibble] & 0xFF);
            }
            if (nibble <= 0) continue;
            sb.append('.');
        }
        sb.append(IPV4_REVERSE_DOMAIN);
        return sb.toString();
    }

    @Override
    public String beginAddressAsString() {
        return Ipv4Interval.numericToTextFormat(this.begin);
    }

    @Override
    public String endAddressAsString() {
        return Ipv4Interval.numericToTextFormat(this.end);
    }

    @Override
    public int compareTo(Ipv4Interval that) {
        if (this.begin() < that.begin()) {
            return -1;
        }
        if (this.begin() > that.begin()) {
            return 1;
        }
        if (that.end() < this.end()) {
            return -1;
        }
        if (that.end() > this.end()) {
            return 1;
        }
        return 0;
    }

    @Override
    public Ipv4Interval singletonIntervalAtLowerBound() {
        return new Ipv4Interval(this.begin(), this.begin());
    }

    @Override
    public int compareUpperBound(Ipv4Interval that) {
        long thatEnd;
        long thisEnd = this.end();
        return thisEnd < (thatEnd = that.end()) ? -1 : (thisEnd > thatEnd ? 1 : 0);
    }

    @Override
    public InetAddress beginAsInetAddress() {
        return InetAddresses.fromInteger((int)this.begin);
    }

    @Override
    public InetAddress endAsInetAddress() {
        return InetAddresses.fromInteger((int)this.end);
    }

    @Override
    public byte[] beginAsByteArray() {
        return Ints.toByteArray((int)this.begin);
    }

    @Override
    public byte[] endAsByteArray() {
        return Ints.toByteArray((int)this.end);
    }

    @Override
    public int getPrefixLength() {
        if (Ipv4Interval.isPowerOfTwo(this.end - this.begin + 1)) {
            return 32 - Integer.numberOfTrailingZeros(this.end - this.begin + 1);
        }
        return -1;
    }
}

