/*
 * Decompiled with CFR 0.152.
 */
package com.bol.ipresource.ip;

import com.bol.ipresource.ip.IpInterval;
import com.bol.ipresource.util.Validate;
import com.google.common.net.InetAddresses;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class Ipv6Interval
extends IpInterval<Ipv6Interval>
implements Comparable<Ipv6Interval> {
    public static final String IPV6_DOTLESS_REVERSE_DOMAIN = ".ip6.arpa";
    public static final String IPV6_REVERSE_DOMAIN = ".ip6.arpa.";
    private static final Pattern REVERSE_PATTERN = Pattern.compile("(?i)^[0-9a-f](?:[.][0-9a-f]){0,31}$");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int LONG_BITCOUNT = 64;
    private static final int IPV6_BITCOUNT = 128;
    public static final Ipv6Interval MAX_RANGE = new Ipv6Interval(0L, 0L, 0);
    private static final BigInteger MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    private final long beginMsb;
    private final long beginLsb;
    private final long endMsb;
    private final long endLsb;

    public Ipv6Interval(BigInteger address, int prefixLength) {
        this(Ipv6Interval.msb(address), Ipv6Interval.lsb(address), prefixLength);
    }

    public Ipv6Interval(String msb, String lsb, int prefixLength) {
        this(new BigInteger(msb).shiftLeft(64).add(new BigInteger(lsb)), prefixLength);
    }

    public Ipv6Interval(long msb, long lsb, int prefixLength) {
        if (prefixLength == 0) {
            this.beginMsb = 0L;
            this.beginLsb = 0L;
            this.endMsb = -1L;
            this.endLsb = -1L;
            return;
        }
        if (prefixLength == 64) {
            this.beginMsb = msb;
            this.beginLsb = 0L;
            this.endMsb = msb;
            this.endLsb = -1L;
            return;
        }
        if (prefixLength == 128) {
            this.beginMsb = msb;
            this.beginLsb = lsb;
            this.endMsb = msb;
            this.endLsb = lsb;
            return;
        }
        long mask = (1L << 64 - prefixLength % 64) - 1L;
        if (prefixLength < 64) {
            this.beginLsb = 0L;
            this.endLsb = -1L;
            this.beginMsb = msb & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            this.endMsb = msb | mask;
        } else {
            this.beginMsb = msb;
            this.endMsb = msb;
            this.beginLsb = lsb & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            this.endLsb = lsb | mask;
        }
    }

    public Ipv6Interval(BigInteger begin, BigInteger end) {
        Validate.isTrue(begin.bitLength() <= 128, "Begin out of range: ", begin);
        Validate.isTrue(end.bitLength() <= 128, "End out of range: ", end);
        this.beginMsb = Ipv6Interval.msb(begin);
        this.beginLsb = Ipv6Interval.lsb(begin);
        this.endMsb = Ipv6Interval.msb(end);
        this.endLsb = Ipv6Interval.lsb(end);
        Validate.isTrue(Ipv6Interval.compare(this.beginMsb, this.beginLsb, this.endMsb, this.endLsb) <= 0, "Begin must be before end");
    }

    public Ipv6Interval(long beginMsb, long beginLsb, long endMsb, long endLsb) {
        this.beginMsb = beginMsb;
        this.beginLsb = beginLsb;
        this.endMsb = endMsb;
        this.endLsb = endLsb;
        Validate.isTrue(Ipv6Interval.compare(beginMsb, beginLsb, endMsb, endLsb) <= 0, "Begin must be before end");
    }

    public static Ipv6Interval parse(InetAddress ipv6Address) {
        return Ipv6Interval.parse(ipv6Address, 128);
    }

    public static Ipv6Interval parse(InetAddress ipv6Address, int prefixLength) {
        long[] res = Ipv6Interval.byteArrayToLongArray(ipv6Address.getAddress());
        return new Ipv6Interval(res[0], res[1], prefixLength);
    }

    public static Ipv6Interval parse(String prefixOrAddress) {
        String trimmedPrefixOrAddress = prefixOrAddress.trim();
        int slashIndex = trimmedPrefixOrAddress.indexOf(47);
        if (slashIndex > 0) {
            int prefixLength = -1;
            try {
                prefixLength = Integer.parseInt(trimmedPrefixOrAddress.substring(slashIndex + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (prefixLength < 0 || prefixLength > 128) {
                throw new IllegalArgumentException("Invalid prefix length: " + prefixOrAddress);
            }
            return Ipv6Interval.parse(InetAddresses.forString((String)trimmedPrefixOrAddress.substring(0, slashIndex)), prefixLength);
        }
        return Ipv6Interval.parse(InetAddresses.forString((String)trimmedPrefixOrAddress), 128);
    }

    public static Ipv6Interval parseIpAddress(String ipAddress) {
        String trimmedPrefixOrAddress = ipAddress.trim();
        return Ipv6Interval.parse(InetAddresses.forString((String)trimmedPrefixOrAddress), 128);
    }

    static int reverseDomainIndex(String cleanAddress) {
        int index = cleanAddress.length() - IPV6_REVERSE_DOMAIN.length();
        if (cleanAddress.startsWith(IPV6_REVERSE_DOMAIN, index)) {
            return index;
        }
        index = cleanAddress.length() - IPV6_DOTLESS_REVERSE_DOMAIN.length();
        if (cleanAddress.startsWith(IPV6_DOTLESS_REVERSE_DOMAIN, index)) {
            return index;
        }
        return -1;
    }

    public static Ipv6Interval parseReverseDomain(String address) {
        Validate.notEmpty(address);
        String cleanAddress = address.trim().toLowerCase();
        int reverseDomainIndex = Ipv6Interval.reverseDomainIndex(cleanAddress);
        Validate.isTrue(reverseDomainIndex >= 0, "Invalid reverse domain: ", address);
        return Ipv6Interval.parseReverseDomain(cleanAddress, reverseDomainIndex);
    }

    static Ipv6Interval parseReverseDomain(String cleanAddress, int reverseDomainIndex) {
        cleanAddress = cleanAddress.substring(0, reverseDomainIndex);
        Validate.isTrue(REVERSE_PATTERN.matcher(cleanAddress).matches(), "Invalid reverse domain: ", cleanAddress);
        StringBuilder builder = new StringBuilder();
        int netmask = 0;
        for (int index = cleanAddress.length() - 1; index >= 0; index -= 2) {
            builder.append(cleanAddress.charAt(index));
            if ((netmask += 4) % 16 != 0 || index <= 0) continue;
            builder.append(':');
        }
        if (netmask % 16 != 0) {
            for (int i = 4 - netmask / 4 % 4; i > 0; --i) {
                builder.append('0');
            }
        }
        if (netmask <= 112) {
            builder.append("::");
        }
        builder.append('/');
        builder.append(netmask);
        return Ipv6Interval.parse(builder.toString());
    }

    public BigInteger beginAsBigInteger() {
        return Ipv6Interval.twoUnsignedLongToBigInteger(this.beginMsb, this.beginLsb);
    }

    public BigInteger endAsBigInteger() {
        return Ipv6Interval.twoUnsignedLongToBigInteger(this.endMsb, this.endLsb);
    }

    private static long[] byteArrayToLongArray(byte[] address) {
        Validate.isTrue(address.length == 16, "Address has to be 16 bytes long");
        long[] res = new long[2];
        for (int i = 0; i < 16; ++i) {
            res[i >>> 3] = (res[i >>> 3] << 8) + (long)(address[i] & 0xFF);
        }
        return res;
    }

    private static byte[] toByteArray(long msb, long lsb) {
        int i;
        byte[] data = new byte[16];
        for (i = 7; i >= 0; --i) {
            data[i] = (byte)(msb & 0xFFL);
            msb >>= 8;
        }
        for (i = 15; i >= 8; --i) {
            data[i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
        return data;
    }

    private static BigInteger twoUnsignedLongToBigInteger(long msb, long lsb) {
        return new BigInteger(1, Ipv6Interval.toByteArray(msb, lsb));
    }

    public static int compare(long aMsb, long aLsb, long bMsb, long bLsb) {
        if (aMsb == bMsb) {
            if (aLsb == bLsb) {
                return 0;
            }
            if (aLsb < bLsb ^ aLsb < 0L ^ bLsb < 0L) {
                return -1;
            }
        } else if (aMsb < bMsb ^ aMsb < 0L ^ bMsb < 0L) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(Ipv6Interval that) {
        int comp = Ipv6Interval.compare(this.beginMsb, this.beginLsb, that.beginMsb, that.beginLsb);
        if (comp == 0) {
            comp = Ipv6Interval.compare(that.endMsb, that.endLsb, this.endMsb, this.endLsb);
        }
        return comp;
    }

    @Override
    public boolean contains(Ipv6Interval that) {
        return Ipv6Interval.compare(this.beginMsb, this.beginLsb, that.beginMsb, that.beginLsb) <= 0 && Ipv6Interval.compare(this.endMsb, this.endLsb, that.endMsb, that.endLsb) >= 0;
    }

    @Override
    public boolean intersects(Ipv6Interval that) {
        return Ipv6Interval.compare(this.beginMsb, this.beginLsb, that.beginMsb, that.beginLsb) >= 0 && Ipv6Interval.compare(this.beginMsb, this.beginLsb, that.endMsb, that.endLsb) <= 0 || Ipv6Interval.compare(this.endMsb, this.endLsb, that.beginMsb, that.beginLsb) >= 0 && Ipv6Interval.compare(this.endMsb, this.endLsb, that.endMsb, that.endLsb) <= 0 || this.contains(that);
    }

    @Override
    public Ipv6Interval singletonIntervalAtLowerBound() {
        return new Ipv6Interval(this.beginMsb, this.beginLsb, 128);
    }

    @Override
    public int compareUpperBound(Ipv6Interval that) {
        return Ipv6Interval.compare(this.endMsb, this.endLsb, that.endMsb, that.endLsb);
    }

    @Override
    public InetAddress beginAsInetAddress() {
        try {
            return Inet6Address.getByAddress(Ipv6Interval.toByteArray(this.beginMsb, this.beginLsb));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public InetAddress endAsInetAddress() {
        try {
            return Inet6Address.getByAddress(Ipv6Interval.toByteArray(this.endMsb, this.endLsb));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public byte[] beginAsByteArray() {
        return Ipv6Interval.toByteArray(this.beginMsb, this.beginLsb);
    }

    @Override
    public byte[] endAsByteArray() {
        return Ipv6Interval.toByteArray(this.endMsb, this.endLsb);
    }

    @Override
    public int getPrefixLength() {
        int res = this.beginMsb == this.endMsb ? 64 + Long.bitCount(this.beginLsb ^ this.endLsb ^ 0xFFFFFFFFFFFFFFFFL) : Long.bitCount(this.beginMsb ^ this.endMsb ^ 0xFFFFFFFFFFFFFFFFL);
        return res;
    }

    private static void numericToTextFormat(StringBuilder sb, long msb, long lsb, int prefixLength) {
        int i;
        int[] nibbles = new int[8];
        int maxZeroIndex = -1;
        int maxZeroCount = -1;
        int actZeroIndex = -1;
        int actZeroCount = 0;
        for (i = 0; i < prefixLength; i += 16) {
            long act = i < 64 ? msb : lsb;
            int remainingPrefix = prefixLength - i;
            int mask = 65535;
            if (remainingPrefix < 16) {
                mask &= ~((1 << 16 - remainingPrefix) - 1);
            }
            nibbles[i >>> 4] = (int)(act >> 48 - (i & 0x3F)) & mask;
        }
        for (i = 0; i < 8; ++i) {
            if (nibbles[i] == 0) {
                if (actZeroIndex >= 0) {
                    ++actZeroCount;
                    continue;
                }
                actZeroIndex = i;
                actZeroCount = 1;
                continue;
            }
            if (actZeroIndex >= 0 && actZeroCount >= maxZeroCount) {
                maxZeroCount = actZeroCount;
                maxZeroIndex = actZeroIndex;
            }
            actZeroIndex = -1;
        }
        if (actZeroIndex >= 0 && actZeroCount >= maxZeroCount) {
            maxZeroCount = actZeroCount;
            maxZeroIndex = actZeroIndex;
        }
        for (i = 0; i < 8; ++i) {
            if (maxZeroIndex == i) {
                if (i == 0) {
                    sb.append("::");
                } else {
                    sb.append(':');
                }
                i += maxZeroCount - 1;
                continue;
            }
            sb.append(Integer.toHexString(nibbles[i]));
            if (i >= 7) continue;
            sb.append(':');
        }
    }

    public String toString() {
        int prefixLength = this.getPrefixLength();
        if (prefixLength < 0) {
            return this.toRangeString();
        }
        StringBuilder sb = new StringBuilder();
        Ipv6Interval.numericToTextFormat(sb, this.beginMsb, this.beginLsb, prefixLength);
        sb.append('/').append(prefixLength);
        return sb.toString();
    }

    @Override
    public String toRangeString() {
        StringBuilder sb = new StringBuilder();
        Ipv6Interval.numericToTextFormat(sb, this.beginMsb, this.beginLsb, 128);
        sb.append(" - ");
        Ipv6Interval.numericToTextFormat(sb, this.endMsb, this.endLsb, 128);
        return sb.toString();
    }

    @Override
    public String toPrefixString() {
        int prefixLength = this.getPrefixLength();
        if (prefixLength < 0) {
            throw new IllegalStateException(this.toRangeString() + " cannot be converted to prefix");
        }
        StringBuilder sb = new StringBuilder();
        Ipv6Interval.numericToTextFormat(sb, this.beginMsb, this.beginLsb, prefixLength);
        sb.append('/').append(prefixLength);
        return sb.toString();
    }

    @Override
    public String toReverseDomain() {
        int prefixLength = this.getPrefixLength();
        if (prefixLength < 0) {
            throw new IllegalArgumentException("Ipv6Interval " + this.toRangeString() + " is not a prefix");
        }
        StringBuilder sb = new StringBuilder();
        for (int digit = 31 - (prefixLength - 1 >> 2); digit < 32; ++digit) {
            int e;
            int b = this.reverseDomainDigit(this.beginMsb, this.beginLsb, digit);
            if (b == (e = this.reverseDomainDigit(this.endMsb, this.endLsb, digit))) {
                sb.append(HEX_DIGITS[b]);
            } else {
                sb.append(HEX_DIGITS[b]).append('-').append(HEX_DIGITS[e]);
            }
            if (digit >= 31) continue;
            sb.append('.');
        }
        sb.append(IPV6_REVERSE_DOMAIN);
        return sb.toString();
    }

    int reverseDomainDigit(long msb, long lsb, int digit) {
        if (digit < 16) {
            return (int)(lsb >> digit * 4) & 0xF;
        }
        return (int)(msb >> (digit - 16) * 4) & 0xF;
    }

    @Override
    public String beginAddressAsString() {
        StringBuilder sb = new StringBuilder();
        Ipv6Interval.numericToTextFormat(sb, this.beginMsb, this.beginLsb, 128);
        return sb.toString();
    }

    @Override
    public String endAddressAsString() {
        StringBuilder sb = new StringBuilder();
        Ipv6Interval.numericToTextFormat(sb, this.endMsb, this.endLsb, 128);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.beginLsb ^ this.beginLsb >>> 32);
        result = 31 * result + (int)(this.beginMsb ^ this.beginMsb >>> 32);
        result = 31 * result + (int)(this.endLsb ^ this.endLsb >>> 32);
        result = 31 * result + (int)(this.endMsb ^ this.endMsb >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ipv6Interval other = (Ipv6Interval)obj;
        return this.compareTo(other) == 0;
    }

    public static long lsb(BigInteger begin) {
        return begin.and(MASK).longValue();
    }

    public static long msb(BigInteger begin) {
        return begin.shiftRight(64).longValue();
    }
}

