/*
 * Decompiled with CFR 0.152.
 */
package com.bol.crypt;

import com.bol.crypt.CryptVersion;
import com.bol.util.JCEPolicy;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.util.function.Function;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class CryptVault {
    private static final Logger LOG = LoggerFactory.getLogger(CryptVault.class);
    static final String DEFAULT_CIPHER = "AES/CBC/PKCS5Padding";
    static final String DEFAULT_ALGORITHM = "AES";
    static final int DEFAULT_SALT_LENGTH = 16;
    private CryptVersion[] cryptVersions = new CryptVersion[256];
    int defaultVersion = -1;
    private SecureRandom SECURE_RANDOM = new SecureRandom();
    static final Function<Integer, Integer> AESLengthCalculator = i -> (i | 0xF) + 1;

    public CryptVault with256BitAesCbcPkcs5PaddingAnd128BitSaltKey(int version, byte[] secret) {
        if (secret.length != 32) {
            throw new IllegalArgumentException("invalid AES key size; should be 256 bits!");
        }
        SecretKeySpec key = new SecretKeySpec(secret, DEFAULT_ALGORITHM);
        CryptVersion cryptVersion = new CryptVersion(16, DEFAULT_CIPHER, key, AESLengthCalculator);
        return this.withKey(version, cryptVersion);
    }

    public CryptVault withKey(int version, CryptVersion cryptVersion) {
        if (version < 0 || version > 255) {
            throw new IllegalArgumentException("version must be a byte");
        }
        if (this.cryptVersions[version] != null) {
            throw new IllegalArgumentException("version " + version + " is already defined");
        }
        this.cryptVersions[version] = cryptVersion;
        if (version > this.defaultVersion) {
            this.defaultVersion = version;
        }
        return this;
    }

    public CryptVault withDefaultKeyVersion(int defaultVersion) {
        if (defaultVersion < 0 || defaultVersion > 255) {
            throw new IllegalArgumentException("version must be a byte");
        }
        if (this.cryptVersions[defaultVersion] == null) {
            throw new IllegalArgumentException("version " + defaultVersion + " is undefined");
        }
        this.defaultVersion = defaultVersion;
        return this;
    }

    Cipher cipher(String cipher) {
        try {
            return Cipher.getInstance(cipher);
        }
        catch (Exception e) {
            throw new IllegalStateException("spring-data-mongodb-encrypt: init failed for cipher " + cipher, e);
        }
    }

    @Scheduled(initialDelay=3600000L, fixedDelay=3600000L)
    public void reinitSecureRandomHourly() {
        this.SECURE_RANDOM = new SecureRandom();
    }

    byte[] urandomBytes(int numBytes) {
        byte[] bytes = new byte[numBytes];
        this.SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }

    public byte[] encrypt(byte[] data) {
        return this.encrypt(this.defaultVersion, data);
    }

    public byte[] encrypt(int version, byte[] data) {
        CryptVersion cryptVersion = this.cryptVersion(version);
        try {
            int cryptedLength = cryptVersion.encryptedLength.apply(data.length);
            byte[] result = new byte[cryptedLength + cryptVersion.saltLength + 1];
            result[0] = CryptVault.toSignedByte(version);
            byte[] random = this.urandomBytes(cryptVersion.saltLength);
            IvParameterSpec iv_spec = new IvParameterSpec(random);
            System.arraycopy(random, 0, result, 1, cryptVersion.saltLength);
            Cipher cipher = this.cipher(cryptVersion.cipher);
            cipher.init(1, cryptVersion.key, iv_spec);
            int len = cipher.doFinal(data, 0, data.length, result, cryptVersion.saltLength + 1);
            if (len < cryptedLength) {
                LOG.info("len was " + len + " instead of " + cryptedLength);
            }
            return result;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new RuntimeException("JCE exception caught while encrypting with version " + version, e);
        }
    }

    public byte[] decrypt(byte[] data) {
        int version = CryptVault.fromSignedByte(data[0]);
        CryptVersion cryptVersion = this.cryptVersion(version);
        try {
            byte[] random = new byte[cryptVersion.saltLength];
            System.arraycopy(data, 1, random, 0, cryptVersion.saltLength);
            IvParameterSpec iv_spec = new IvParameterSpec(random);
            Cipher cipher = this.cipher(this.cryptVersions[version].cipher);
            cipher.init(2, this.cryptVersions[version].key, iv_spec);
            return cipher.doFinal(data, cryptVersion.saltLength + 1, data.length - cryptVersion.saltLength - 1);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("JCE exception caught while decrypting with version " + version, e);
        }
    }

    public int expectedCryptedLength(int serializedLength) {
        return this.expectedCryptedLength(this.defaultVersion, serializedLength);
    }

    public int expectedCryptedLength(int version, int serializedLength) {
        CryptVersion cryptVersion = this.cryptVersion(version);
        return cryptVersion.saltLength + 1 + cryptVersion.encryptedLength.apply(serializedLength);
    }

    private CryptVersion cryptVersion(int version) {
        try {
            CryptVersion result = this.cryptVersions[version];
            if (result == null) {
                throw new IllegalArgumentException("version " + version + " undefined");
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            if (version < 0) {
                throw new IllegalStateException("encryption keys are not initialized");
            }
            throw new IllegalArgumentException("version must be a byte (0-255)");
        }
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.cryptVersions.length; ++i) {
            if (this.cryptVersions[i] == null) continue;
            ++size;
        }
        return size;
    }

    public static byte toSignedByte(int val) {
        return (byte)(val + -128);
    }

    public static int fromSignedByte(byte val) {
        return val - -128;
    }

    static {
        JCEPolicy.allowUnlimitedStrength();
    }
}

