/*
 * Decompiled with CFR 0.152.
 */
package com.bol.secure;

import com.bol.crypt.CryptVault;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.function.Function;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.types.Binary;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;

public class AbstractEncryptionEventListener
extends AbstractMongoEventListener {
    protected CryptVault cryptVault;

    public AbstractEncryptionEventListener(CryptVault cryptVault) {
        this.cryptVault = cryptVault;
    }

    class Encoder
    extends BasicBSONEncoder
    implements Function<Object, Object> {
        Encoder() {
        }

        @Override
        public Object apply(Object o) {
            byte[] serialized = this.encode((BSONObject)new BasicBSONObject("", o));
            return new Binary(AbstractEncryptionEventListener.this.cryptVault.encrypt(serialized));
        }
    }

    class BasicDBObjectCallback
    extends BasicBSONCallback {
        BasicDBObjectCallback() {
        }

        public BSONObject create() {
            return new BasicDBObject();
        }

        protected BSONObject createList() {
            return new BasicDBList();
        }

        public BSONCallback createBSONCallback() {
            return new BasicDBObjectCallback();
        }
    }

    class Decoder
    extends BasicBSONDecoder
    implements Function<Object, Object> {
        Decoder() {
        }

        @Override
        public Object apply(Object o) {
            byte[] serialized = AbstractEncryptionEventListener.this.cryptVault.decrypt((byte[])o);
            BasicDBObjectCallback bsonCallback = new BasicDBObjectCallback();
            this.decode(serialized, (BSONCallback)bsonCallback);
            BSONObject deserialized = (BSONObject)bsonCallback.get();
            return deserialized.get("");
        }
    }
}

