/*
 * Decompiled with CFR 0.152.
 */
package com.bol.secure;

import com.bol.crypt.CryptVault;
import com.bol.reflection.Node;
import com.bol.reflection.ReflectionCache;
import com.bol.secure.AbstractEncryptionEventListener;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;

public class CachedEncryptionEventListener
extends AbstractEncryptionEventListener {
    @Autowired
    MongoMappingContext mappingContext;
    Map<Class, Node> encrypted;

    public CachedEncryptionEventListener(CryptVault cryptVault) {
        super(cryptVault);
    }

    @PostConstruct
    public void initReflection() {
        this.encrypted = new HashMap<Class, Node>();
        this.mappingContext.getPersistentEntities().forEach(entity -> {
            List<Node> children = ReflectionCache.processDocument(entity.getType());
            if (!children.isEmpty()) {
                this.encrypted.put(entity.getType(), new Node("", children, Node.Type.ROOT));
            }
        });
    }

    public void onAfterLoad(AfterLoadEvent event) {
        DBObject dbObject = event.getDBObject();
        Node node = this.encrypted.get(event.getType());
        if (node == null) {
            return;
        }
        this.cryptFields(dbObject, node, new AbstractEncryptionEventListener.Decoder());
    }

    public void onBeforeSave(BeforeSaveEvent event) {
        DBObject dbObject = event.getDBObject();
        Node node = this.encrypted.get(event.getSource().getClass());
        if (node == null) {
            return;
        }
        this.cryptFields(dbObject, node, new AbstractEncryptionEventListener.Encoder());
    }

    void cryptFields(DBObject dbObject, Node node, Function<Object, Object> crypt) {
        if (node.type == Node.Type.MAP) {
            Node mapChildren = node.children.get(0);
            for (Object entry : ((BasicDBObject)dbObject).values()) {
                this.cryptFields((DBObject)entry, mapChildren, crypt);
            }
            return;
        }
        if (node.type == Node.Type.LIST) {
            Node mapChildren = node.children.get(0);
            for (Object entry : (BasicDBList)dbObject) {
                this.cryptFields((DBObject)entry, mapChildren, crypt);
            }
            return;
        }
        for (Node childNode : node.children) {
            Object value = dbObject.get(childNode.fieldName);
            if (value == null) continue;
            if (!childNode.children.isEmpty()) {
                if (value instanceof BasicDBList) {
                    for (Object o : (BasicDBList)value) {
                        this.cryptFields((DBObject)o, childNode.children.get(0), crypt);
                    }
                } else {
                    this.cryptFields((DBObject)((BasicDBObject)value), childNode, crypt);
                }
                return;
            }
            dbObject.put(childNode.fieldName, crypt.apply(value));
        }
    }
}

