/*
 * Decompiled with CFR 0.152.
 */
package com.bol.secure;

import com.bol.crypt.CryptVault;
import com.bol.secure.AbstractEncryptionEventListener;
import com.bol.secure.Encrypted;
import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.bson.types.BasicBSONList;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.util.ReflectionUtils;

public class ReflectionEncryptionEventListener
extends AbstractEncryptionEventListener {
    public ReflectionEncryptionEventListener(CryptVault cryptVault) {
        super(cryptVault);
    }

    public void onAfterLoad(AfterLoadEvent event) {
        DBObject dbObject = event.getDBObject();
        ReflectionEncryptionEventListener.cryptFields(dbObject, event.getType(), new AbstractEncryptionEventListener.Decoder());
    }

    public void onBeforeSave(BeforeSaveEvent event) {
        DBObject dbObject = event.getDBObject();
        ReflectionEncryptionEventListener.cryptFields(dbObject, event.getSource().getClass(), new AbstractEncryptionEventListener.Encoder());
    }

    static void cryptFields(DBObject dbObject, Class node, Function<Object, Object> crypt) {
        for (String fieldName : dbObject.keySet()) {
            Type subFieldType;
            ParameterizedType parameterizedType;
            Field field;
            if (fieldName.equals("_class") || (field = ReflectionUtils.findField((Class)node, (String)fieldName)) == null) continue;
            if (field.isAnnotationPresent(Encrypted.class)) {
                Object value = dbObject.get(fieldName);
                dbObject.put(fieldName, crypt.apply(value));
                continue;
            }
            Class<?> fieldType = field.getType();
            if (Collection.class.isAssignableFrom(fieldType)) {
                parameterizedType = (ParameterizedType)field.getGenericType();
                subFieldType = parameterizedType.getActualTypeArguments()[0];
                BasicDBList list = (BasicDBList)dbObject.get(fieldName);
                for (Object o : list) {
                    ReflectionEncryptionEventListener.diveInto(crypt, (DBObject)o, subFieldType);
                }
                continue;
            }
            if (Map.class.isAssignableFrom(fieldType)) {
                parameterizedType = (ParameterizedType)field.getGenericType();
                subFieldType = parameterizedType.getActualTypeArguments()[1];
                DBObject map = (DBObject)dbObject.get(fieldName);
                for (String key : map.keySet()) {
                    ReflectionEncryptionEventListener.diveInto(crypt, (DBObject)map.get(key), subFieldType);
                }
                continue;
            }
            Object o = dbObject.get(fieldName);
            if (!(o instanceof DBObject)) continue;
            DBObject subObject = (DBObject)o;
            ReflectionEncryptionEventListener.diveInto(crypt, subObject, fieldType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void diveInto(Function<Object, Object> crypt, DBObject value, Type fieldType) {
        Class childNode = ReflectionEncryptionEventListener.fetchClassFromField(value);
        if (childNode != null) {
            ReflectionEncryptionEventListener.cryptFields(value, childNode, crypt);
            return;
        }
        if (fieldType instanceof Class) {
            childNode = (Class)fieldType;
            ReflectionEncryptionEventListener.cryptFields(value, childNode, crypt);
            return;
        } else {
            if (!(fieldType instanceof ParameterizedType)) throw new IllegalArgumentException("Unknown reflective type class " + fieldType.getClass());
            ParameterizedType subType = (ParameterizedType)fieldType;
            Class rawType = (Class)subType.getRawType();
            if (Collection.class.isAssignableFrom(rawType)) {
                Type subFieldType = subType.getActualTypeArguments()[0];
                BasicDBList list = (BasicDBList)value;
                for (Object o : list) {
                    ReflectionEncryptionEventListener.diveInto(crypt, (DBObject)o, subFieldType);
                }
                return;
            } else {
                if (!Map.class.isAssignableFrom(rawType)) throw new IllegalArgumentException("Unknown reflective raw type class " + rawType.getClass() + "; should be Map<> or Collection<>");
                Type subFieldType = subType.getActualTypeArguments()[1];
                for (String key : value.keySet()) {
                    ReflectionEncryptionEventListener.diveInto(crypt, (DBObject)value.get(key), subFieldType);
                }
            }
        }
    }

    private static Class<?> fetchClassFromField(DBObject value) {
        if (value instanceof BasicBSONList) {
            return null;
        }
        String className = (String)value.get("_class");
        if (className != null) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

