/*
 * Decompiled with CFR 0.152.
 */
package com.bol.config;

import com.bol.config.CryptVaultAutoConfiguration;
import com.bol.crypt.CryptVault;
import com.bol.secure.AbstractEncryptionEventListener;
import com.bol.secure.CachedEncryptionEventListener;
import com.bol.secure.ReflectionEncryptionEventListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
public class EncryptAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CryptVault.class})
    @ConditionalOnProperty(prefix="mongodb.encrypt", name={"keys[0].key"})
    CryptVault cryptVault(EncryptConfigurationProperties properties) {
        return new CryptVaultAutoConfiguration().cryptVault((CryptVaultAutoConfiguration.CryptVaultConfigurationProperties)properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractEncryptionEventListener.class})
    @ConditionalOnBean(value={CryptVault.class})
    AbstractEncryptionEventListener encryptionEventListener(CryptVault cryptVault, EncryptConfigurationProperties properties) {
        AbstractEncryptionEventListener eventListener = "reflection".equalsIgnoreCase(properties.type) ? new ReflectionEncryptionEventListener(cryptVault) : new CachedEncryptionEventListener(cryptVault);
        if (properties.silentDecryptionFailures == Boolean.TRUE) {
            eventListener.withSilentDecryptionFailure(true);
        }
        return eventListener;
    }

    @Component
    @ConfigurationProperties(value="mongodb.encrypt")
    public static class EncryptConfigurationProperties
    extends CryptVaultAutoConfiguration.CryptVaultConfigurationProperties {
        String type;
        Boolean silentDecryptionFailures;

        public void setType(String type) {
            this.type = type;
        }

        public void setSilentDecryptionFailures(Boolean silentDecryptionFailures) {
            this.silentDecryptionFailures = silentDecryptionFailures;
        }
    }
}

