/*
 * Decompiled with CFR 0.152.
 */
package com.bol.reflection;

import com.bol.reflection.Node;
import com.bol.secure.FieldEncryptedPredicate;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.util.ReflectionUtils;

public class ReflectionCache {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionCache.class);
    private final ConcurrentHashMap<Class<?>, List<Node>> reflectionCache = new ConcurrentHashMap();
    private final FieldEncryptedPredicate fieldEncryptedPredicate;
    private static final Set<Class<?>> primitiveClasses = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Void.class, String.class));

    public ReflectionCache(FieldEncryptedPredicate fieldEncryptedPredicate) {
        this.fieldEncryptedPredicate = fieldEncryptedPredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Node> reflectRecursive(Class<?> objectClass) {
        List<Node> nodes = this.reflectionCache.get(objectClass);
        if (nodes != null) {
            return nodes;
        }
        ReflectionCache reflectionCache = this;
        synchronized (reflectionCache) {
            return this.buildRecursive(objectClass, new HashMap());
        }
    }

    private List<Node> buildRecursive(Class<?> objectClass, HashMap<Class<?>, List<Node>> building) {
        if (ReflectionCache.isPrimitive(objectClass)) {
            return Collections.emptyList();
        }
        List<Node> processed = this.reflectionCache.get(objectClass);
        if (processed != null) {
            return processed;
        }
        List<Node> processing = building.get(objectClass);
        if (processing != null) {
            return processing;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        building.put(objectClass, nodes);
        ReflectionUtils.doWithFields(objectClass, field -> {
            String fieldName = field.getName();
            try {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
                    return;
                }
                String documentName = ReflectionCache.parseFieldAnnotation(field, fieldName);
                if (this.fieldEncryptedPredicate.test(field)) {
                    nodes.add(new Node(fieldName, documentName, Collections.emptyList(), Node.Type.DIRECT, field));
                } else {
                    Class<?> fieldType = field.getType();
                    Type fieldGenericType = field.getGenericType();
                    if (Collection.class.isAssignableFrom(fieldType)) {
                        List<Node> children = this.processParameterizedTypes(fieldGenericType, building);
                        if (!children.isEmpty()) {
                            nodes.add(new Node(fieldName, documentName, ReflectionCache.unwrap(children), Node.Type.LIST, field));
                        }
                    } else if (Map.class.isAssignableFrom(fieldType)) {
                        List<Node> children = this.processParameterizedTypes(fieldGenericType, building);
                        if (!children.isEmpty()) {
                            nodes.add(new Node(fieldName, documentName, ReflectionCache.unwrap(children), Node.Type.MAP, field));
                        }
                    } else {
                        List<Node> children = this.buildRecursive(fieldType, building);
                        if (!children.isEmpty()) {
                            nodes.add(new Node(fieldName, documentName, children, Node.Type.DOCUMENT, field));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(objectClass.getName() + "." + fieldName, e);
            }
        });
        this.reflectionCache.put(objectClass, nodes);
        return nodes;
    }

    public List<Node> reflectSingle(Class<?> objectClass) {
        return this.reflectionCache.computeIfAbsent(objectClass, this::buildSingle);
    }

    private List<Node> buildSingle(Class<?> objectClass) {
        if (ReflectionCache.isPrimitive(objectClass)) {
            return Collections.emptyList();
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        ReflectionUtils.doWithFields(objectClass, field -> {
            String fieldName = field.getName();
            try {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) {
                    return;
                }
                String documentName = ReflectionCache.parseFieldAnnotation(field, fieldName);
                if (this.fieldEncryptedPredicate.test(field)) {
                    nodes.add(new Node(fieldName, documentName, Collections.emptyList(), Node.Type.DIRECT, field));
                } else {
                    Class<?> fieldType = field.getType();
                    if (Collection.class.isAssignableFrom(fieldType)) {
                        nodes.add(new Node(fieldName, documentName, Collections.emptyList(), Node.Type.LIST, field));
                    } else if (Map.class.isAssignableFrom(fieldType)) {
                        nodes.add(new Node(fieldName, documentName, Collections.emptyList(), Node.Type.MAP, field));
                    } else {
                        nodes.add(new Node(fieldName, documentName, Collections.emptyList(), Node.Type.DOCUMENT, field));
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(objectClass.getName() + "." + fieldName, e);
            }
        });
        return nodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Node> processParameterizedTypes(Type type, HashMap<Class<?>, List<Node>> building) {
        if (type instanceof Class) {
            List<Node> children = this.buildRecursive((Class)type, building);
            if (children.isEmpty()) return Collections.emptyList();
            return Collections.singletonList(new Node(null, children, Node.Type.DOCUMENT));
        }
        if (!(type instanceof ParameterizedType)) throw new IllegalArgumentException("Unknown reflective type class " + type.getClass());
        ParameterizedType subType = (ParameterizedType)type;
        Class rawType = (Class)subType.getRawType();
        if (Collection.class.isAssignableFrom(rawType)) {
            List<Node> children = this.processParameterizedTypes(subType.getActualTypeArguments()[0], building);
            if (children.isEmpty()) return Collections.emptyList();
            return Collections.singletonList(new Node(null, children, Node.Type.LIST));
        }
        if (!Map.class.isAssignableFrom(rawType)) throw new IllegalArgumentException("Unknown reflective raw type class " + rawType);
        List<Node> children = this.processParameterizedTypes(subType.getActualTypeArguments()[1], building);
        if (children.isEmpty()) return Collections.emptyList();
        return Collections.singletonList(new Node(null, children, Node.Type.MAP));
    }

    static List<Node> unwrap(List<Node> result) {
        if (result.size() != 1) {
            return result;
        }
        Node node = result.get(0);
        if (node.fieldName != null) {
            return result;
        }
        return node.children;
    }

    static String parseFieldAnnotation(java.lang.reflect.Field field, String fieldName) {
        Field fieldAnnotation = field.getAnnotation(Field.class);
        if (fieldAnnotation != null) {
            String name = fieldAnnotation.name();
            if (!name.isEmpty()) {
                return name;
            }
            String value = fieldAnnotation.value();
            if (!value.isEmpty()) {
                return value;
            }
        }
        return fieldName;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || primitiveClasses.contains(clazz);
    }
}

