/*
 * Decompiled with CFR 0.152.
 */
package com.bol.secure;

import com.bol.crypt.CryptVault;
import com.bol.crypt.DocumentCryptException;
import com.bol.crypt.FieldCryptException;
import com.bol.reflection.Node;
import com.bol.reflection.ReflectionCache;
import com.bol.secure.AbstractEncryptionEventListener;
import com.bol.secure.FieldEncryptedPredicate;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bson.Document;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;

public class CachedEncryptionEventListener
extends AbstractEncryptionEventListener<CachedEncryptionEventListener> {
    final ReflectionCache reflectionCache;

    public CachedEncryptionEventListener(CryptVault cryptVault) {
        this(cryptVault, FieldEncryptedPredicate.ANNOTATION_PRESENT);
    }

    public CachedEncryptionEventListener(CryptVault cryptVault, FieldEncryptedPredicate fieldEncryptedPredicate) {
        super(cryptVault);
        this.reflectionCache = new ReflectionCache(fieldEncryptedPredicate);
    }

    Node node(Class<?> clazz) {
        List<Node> children = this.reflectionCache.reflectRecursive(clazz);
        if (!children.isEmpty()) {
            return new Node("", children, Node.Type.DOCUMENT);
        }
        return Node.EMPTY;
    }

    public void onAfterLoad(AfterLoadEvent event) {
        Document document = event.getDocument();
        Node node = this.node(event.getType());
        if (node == Node.EMPTY) {
            return;
        }
        try {
            this.cryptFields(document, node, new AbstractEncryptionEventListener.Decoder());
        }
        catch (Exception e) {
            Object id = document.get((Object)"_id");
            throw new DocumentCryptException(event.getCollectionName(), id, e);
        }
    }

    public void onBeforeSave(BeforeSaveEvent event) {
        Document document = event.getDocument();
        Node node = this.node(event.getSource().getClass());
        if (node == Node.EMPTY) {
            return;
        }
        try {
            this.cryptFields(document, node, new AbstractEncryptionEventListener.Encoder());
        }
        catch (Exception e) {
            Object id = document.get((Object)"_id");
            throw new DocumentCryptException(event.getCollectionName(), id, e);
        }
    }

    void cryptFields(Object o, Node node, Function<Object, Object> crypt) {
        try {
            switch (node.type) {
                case MAP: {
                    this.cryptMap((Document)o, node, crypt);
                    break;
                }
                case DOCUMENT: {
                    this.cryptDocument((Document)o, node, crypt);
                    break;
                }
                case LIST: {
                    this.cryptList((List)o, node, crypt);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown class field to crypt for field " + node.fieldName + ": " + o.getClass());
                }
            }
        }
        catch (ClassCastException e) {
            throw new FieldCryptException(node.fieldName, e);
        }
    }

    void cryptList(List<?> list, Node node, Function<Object, Object> crypt) {
        if (node.type != Node.Type.LIST) {
            throw new IllegalArgumentException("Expected list for " + node.fieldName + ", got " + (Object)((Object)node.type));
        }
        Node mapChildren = node.children.get(0);
        for (int i = 0; i < list.size(); ++i) {
            try {
                this.cryptFields(list.get(i), mapChildren, crypt);
                continue;
            }
            catch (FieldCryptException e) {
                throw e.chain(Integer.toString(i));
            }
        }
    }

    void cryptMap(Document document, Node node, Function<Object, Object> crypt) {
        Node mapChildren = node.children.get(0);
        for (Map.Entry entry : document.entrySet()) {
            try {
                this.cryptFields(entry.getValue(), mapChildren, crypt);
            }
            catch (FieldCryptException e) {
                throw e.chain((String)entry.getKey());
            }
        }
    }

    void cryptDocument(Document document, Node node, Function<Object, Object> crypt) {
        for (Node childNode : node.children) {
            Object value = document.get((Object)childNode.documentName);
            if (value == null) continue;
            if (childNode.type == Node.Type.DIRECT) {
                try {
                    document.put(childNode.documentName, crypt.apply(value));
                    continue;
                }
                catch (Exception e) {
                    throw new FieldCryptException(childNode.fieldName, e);
                }
            }
            try {
                this.cryptFields(value, childNode, crypt);
            }
            catch (FieldCryptException e) {
                throw e.chain(childNode.fieldName);
            }
        }
    }
}

