/*
 * Decompiled with CFR 0.152.
 */
package com.bol.secure;

import com.bol.crypt.CryptVault;
import com.bol.crypt.DocumentCryptException;
import com.bol.crypt.FieldCryptException;
import com.bol.reflection.Node;
import com.bol.reflection.ReflectionCache;
import com.bol.secure.AbstractEncryptionEventListener;
import com.bol.secure.FieldEncryptedPredicate;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bson.Document;
import org.springframework.data.mongodb.core.mapping.event.AfterLoadEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;

public class ReflectionEncryptionEventListener
extends AbstractEncryptionEventListener<ReflectionEncryptionEventListener> {
    final ReflectionCache reflectionCache;

    public ReflectionEncryptionEventListener(CryptVault cryptVault) {
        this(cryptVault, FieldEncryptedPredicate.ANNOTATION_PRESENT);
    }

    public ReflectionEncryptionEventListener(CryptVault cryptVault, FieldEncryptedPredicate fieldEncryptedPredicate) {
        super(cryptVault);
        this.reflectionCache = new ReflectionCache(fieldEncryptedPredicate);
    }

    void cryptDocument(Document document, Class<?> clazz, Function<Object, Object> crypt) {
        List<Node> nodes = this.reflectionCache.reflectSingle(clazz);
        for (Map.Entry field : document.entrySet()) {
            Node node;
            String documentName = (String)field.getKey();
            if (documentName.equals("_class") || (node = ReflectionEncryptionEventListener.find(nodes, documentName)) == null) continue;
            Object fieldValue = field.getValue();
            if (node.type == Node.Type.DIRECT) {
                try {
                    document.put(documentName, crypt.apply(fieldValue));
                    continue;
                }
                catch (Exception e) {
                    throw new FieldCryptException(documentName, e);
                }
            }
            try {
                this.diveInto(fieldValue, node.field.getGenericType(), crypt);
            }
            catch (FieldCryptException e) {
                throw e.chain(documentName);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void diveInto(Object value, Type type, Function<Object, Object> crypt) {
        void var8_10;
        Type subFieldType;
        if (ReflectionCache.isPrimitive(value.getClass())) {
            return;
        }
        Class reflectiveClass = null;
        Type[] typeArguments = null;
        if (type instanceof Class) {
            reflectiveClass = (Class)type;
        } else {
            if (!(type instanceof ParameterizedType)) throw new IllegalArgumentException("Unknown reflective type class " + type);
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            typeArguments = parameterizedType.getActualTypeArguments();
            if (!(rawType instanceof Class)) {
                throw new IllegalArgumentException("Unknown reflective type class " + type);
            }
            reflectiveClass = (Class)rawType;
        }
        if (value instanceof Document) {
            if (Map.class.isAssignableFrom(reflectiveClass)) {
                subFieldType = typeArguments[1];
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    try {
                        this.diveInto(entry.getValue(), subFieldType, crypt);
                    }
                    catch (FieldCryptException e) {
                        throw e.chain(entry.getKey().toString());
                    }
                }
                return;
            } else {
                Class<?> childNode = ReflectionEncryptionEventListener.fetchClassFromField((Document)value);
                if (childNode != null) {
                    this.cryptDocument((Document)value, childNode, crypt);
                    return;
                } else {
                    this.cryptDocument((Document)value, reflectiveClass, crypt);
                }
            }
            return;
        }
        if (!(value instanceof List)) throw new IllegalArgumentException("Unknown reflective value class: " + value.getClass());
        if (!Collection.class.isAssignableFrom(reflectiveClass)) throw new IllegalArgumentException("Unknown reflective type class " + type.getClass());
        subFieldType = typeArguments[0];
        List list = (List)value;
        boolean bl = false;
        while (var8_10 < list.size()) {
            try {
                this.diveInto(list.get((int)var8_10), subFieldType, crypt);
            }
            catch (FieldCryptException e) {
                throw e.chain(Integer.toString((int)var8_10));
            }
            ++var8_10;
        }
    }

    private static Class<?> fetchClassFromField(Document value) {
        String className = (String)value.get((Object)"_class");
        if (className != null) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ignored) {
                throw new IllegalArgumentException("Unknown _class field reference: " + className);
            }
        }
        return null;
    }

    private static Node find(List<Node> nodes, String documentName) {
        for (Node node : nodes) {
            if (!node.documentName.equals(documentName)) continue;
            return node;
        }
        return null;
    }

    public void onAfterLoad(AfterLoadEvent event) {
        Document document = event.getDocument();
        try {
            this.cryptDocument(document, event.getType(), new AbstractEncryptionEventListener.Decoder());
        }
        catch (Exception e) {
            Object id = document.get((Object)"_id");
            throw new DocumentCryptException(event.getCollectionName(), id, e);
        }
    }

    public void onBeforeSave(BeforeSaveEvent event) {
        Document document = event.getDocument();
        try {
            this.cryptDocument(document, event.getSource().getClass(), new AbstractEncryptionEventListener.Encoder());
        }
        catch (Exception e) {
            Object id = document.get((Object)"_id");
            throw new DocumentCryptException(event.getCollectionName(), id, e);
        }
    }
}

