/*
 * Decompiled with CFR 0.152.
 */
package com.booking.perfsuite.rendering;

import android.util.SparseIntArray;
import com.booking.perfsuite.rendering.RenderingMetrics;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J'\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/booking/perfsuite/rendering/RenderingMetricsMapper;", "", "()V", "FROZEN_FRAME_THRESHOLD_MS", "", "MAX_FRAME_DURATION_MS", "SLOW_FRAME_THRESHOLD_MS", "isValidDuration", "", "frameDuration", "toRenderingMetrics", "Lcom/booking/perfsuite/rendering/RenderingMetrics;", "metrics", "", "Landroid/util/SparseIntArray;", "foregroundTime", "", "([Landroid/util/SparseIntArray;Ljava/lang/Long;)Lcom/booking/perfsuite/rendering/RenderingMetrics;", "perfsuite_release"})
@SourceDebugExtension(value={"SMAP\nRenderingMetricsMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderingMetricsMapper.kt\ncom/booking/perfsuite/rendering/RenderingMetricsMapper\n+ 2 SparseIntArray.kt\nandroidx/core/util/SparseIntArrayKt\n*L\n1#1,86:1\n55#2:87\n75#2,4:88\n*S KotlinDebug\n*F\n+ 1 RenderingMetricsMapper.kt\ncom/booking/perfsuite/rendering/RenderingMetricsMapper\n*L\n20#1:87\n28#1:88,4\n*E\n"})
public final class RenderingMetricsMapper {
    @NotNull
    public static final RenderingMetricsMapper INSTANCE = new RenderingMetricsMapper();
    private static final int SLOW_FRAME_THRESHOLD_MS = 16;
    private static final int FROZEN_FRAME_THRESHOLD_MS = 700;
    private static final int MAX_FRAME_DURATION_MS = 5000;

    private RenderingMetricsMapper() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RenderingMetrics toRenderingMetrics(@Nullable SparseIntArray[] metrics, @Nullable Long foregroundTime) {
        SparseIntArray totalMetrics;
        block7: {
            block6: {
                SparseIntArray sparseIntArray = totalMetrics = metrics != null ? (SparseIntArray)ArraysKt.getOrNull((Object[])metrics, (int)0) : null;
                if (totalMetrics == null) break block6;
                SparseIntArray $this$isEmpty$iv = totalMetrics;
                boolean $i$f$isEmpty = false;
                if (!($this$isEmpty$iv.size() == 0)) break block7;
            }
            return null;
        }
        long total = 0L;
        long slow = 0L;
        long frozen = 0L;
        long dropped = 0L;
        long totalFreezeTime = 0L;
        SparseIntArray $this$forEach$iv = totalMetrics;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void numberOfFrames;
            int n2 = $this$forEach$iv.valueAt(index$iv);
            int frameDuration = $this$forEach$iv.keyAt(index$iv);
            boolean bl = false;
            if (!INSTANCE.isValidDuration(frameDuration)) continue;
            if (frameDuration > 700) {
                frozen += (long)numberOfFrames;
            }
            if (frameDuration > 16) {
                slow += (long)numberOfFrames;
                totalFreezeTime += (long)(frameDuration * numberOfFrames);
            }
            total += (long)numberOfFrames;
            dropped += (long)(frameDuration / 16 * numberOfFrames);
        }
        return new RenderingMetrics(total, slow, frozen, dropped, totalFreezeTime, foregroundTime);
    }

    private final boolean isValidDuration(int frameDuration) {
        return 0 <= frameDuration ? frameDuration < 5000 : false;
    }
}

