/*
 * Decompiled with CFR 0.152.
 */
package com.booking.perfsuite.startup;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.UiThread;
import com.booking.perfsuite.internal.FrameDrawUtilKt;
import com.booking.perfsuite.internal.SystemUtilKt;
import com.booking.perfsuite.startup.AppStartTimeProvider;
import com.booking.perfsuite.startup.AppStartupTimeTracker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lcom/booking/perfsuite/startup/AppStartupTimeTracker;", "", "()V", "register", "", "application", "Landroid/app/Application;", "listener", "Lcom/booking/perfsuite/startup/AppStartupTimeTracker$Listener;", "Listener", "perfsuite_release"})
public final class AppStartupTimeTracker {
    @NotNull
    public static final AppStartupTimeTracker INSTANCE = new AppStartupTimeTracker();

    private AppStartupTimeTracker() {
    }

    @JvmStatic
    public static final void register(@NotNull Application application, @NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!SystemUtilKt.isForegroundProcess()) {
            return;
        }
        long appOnCreateTime = SystemUtilKt.nowMillis();
        long appStartTime = AppStartTimeProvider.Companion.getAppStartTime(appOnCreateTime);
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(application, appStartTime, listener){
            private boolean isInterrupted;
            final /* synthetic */ Application $application;
            final /* synthetic */ long $appStartTime;
            final /* synthetic */ Listener $listener;
            {
                this.$application = $application;
                this.$appStartTime = $appStartTime;
                this.$listener = $listener;
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                FrameDrawUtilKt.doOnFirstDraw(activity, (Function0<Unit>)((Function0)new Function0<Unit>(this, this.$application, this.$appStartTime, savedInstanceState, this.$listener, activity){
                    final /* synthetic */ register.1 this$0;
                    final /* synthetic */ Application $application;
                    final /* synthetic */ long $appStartTime;
                    final /* synthetic */ Bundle $savedInstanceState;
                    final /* synthetic */ Listener $listener;
                    final /* synthetic */ Activity $activity;
                    {
                        this.this$0 = $receiver;
                        this.$application = $application;
                        this.$appStartTime = $appStartTime;
                        this.$savedInstanceState = $savedInstanceState;
                        this.$listener = $listener;
                        this.$activity = $activity;
                        super(0);
                    }

                    public final void invoke() {
                        if (!register.1.access$isInterrupted$p(this.this$0)) {
                            this.$application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.this$0);
                            long duration = SystemUtilKt.nowMillis() - this.$appStartTime;
                            boolean isActualColdStart = this.$savedInstanceState == null;
                            this.$listener.onColdStartupTimeIsReady(duration, this.$activity, isActualColdStart);
                        }
                    }
                }));
            }

            public void onActivityPaused(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                this.isInterrupted = true;
            }

            public void onActivityStarted(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
            }

            public void onActivityStopped(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public void onActivityResumed(@NotNull Activity activity) {
                Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            }

            public static final /* synthetic */ boolean access$isInterrupted$p(register.1 $this) {
                return $this.isInterrupted;
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH'\u00a8\u0006\n"}, d2={"Lcom/booking/perfsuite/startup/AppStartupTimeTracker$Listener;", "", "onColdStartupTimeIsReady", "", "startupTime", "", "firstActivity", "Landroid/app/Activity;", "isActualColdStart", "", "perfsuite_release"})
    public static interface Listener {
        @UiThread
        public void onColdStartupTimeIsReady(long var1, @NotNull Activity var3, boolean var4);
    }
}

