/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda;

import com.boozallen.aiops.mda.DockerBuildParams;
import com.boozallen.aiops.mda.generator.util.MavenUtil;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.notification.Notification;
import org.technologybrewery.fermenter.mda.notification.NotificationCollector;
import org.technologybrewery.fermenter.mda.notification.VelocityNotification;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Named
public class ManualActionNotificationService {
    private static final Logger logger = LoggerFactory.getLogger(ManualActionNotificationService.class);
    private static final String EMPTY_LINE = "\n";
    private static final String SUPPRESS_WARNINGS = "maven-suppress-warnings";
    public static final String GROUP_TILT = "tilt";

    public void addSchemaElementDeprecationNotice(String illegalElement, String objectType) {
        String SCHEMA_ELEMENT_DEPRECATION_KEY = "schema_element_deprecation";
        VelocityNotification notification = new VelocityNotification(this.getMessageKey("schema_element_deprecation", illegalElement), "schemaelementdeprecation", new HashSet(), "templates/notifications/notification.schema.element.deprecation.vm");
        notification.addToVelocityContext("objectType", (Object)objectType);
        notification.addToVelocityContext("illegalElement", (Object)illegalElement);
        this.addManualAction("schema_element_deprecation", (Notification)notification);
    }

    public void addNoticeToAddPipelines(GenerationContext context) {
        String ADD_PIPELINES_KEY = "add_pipelines";
        String pathToReadMe = context.getProjectDirectory().toString().replace("pipelines", "pipeline-models/pipelines/README.md");
        VelocityNotification notification = new VelocityNotification("add_pipelines", new HashSet(), "templates/notifications/notification.pipelines.vm");
        notification.addToVelocityContext("pathToReadMe", (Object)pathToReadMe);
        this.addManualAction("add_pipelines", (Notification)notification);
    }

    public void addNoticeToAddModuleToParentBuild(GenerationContext context, String artifactId, String moduleType) {
        String pomFilePath = context.getProjectDirectory() + File.separator + "pom.xml";
        String query = "<module>" + artifactId + "</module>";
        boolean alreadyExists = this.existsInFile(pomFilePath, query);
        String relativePomFilePath = this.getRelativePathToProjectRoot(context.getExecutionRootDirectory(), new File(pomFilePath));
        if (!alreadyExists) {
            String key = this.getMessageKey(relativePomFilePath, "module");
            HashSet<CallSite> items = new HashSet<CallSite>();
            items.add((CallSite)((Object)("<module>" + artifactId + "</module>")));
            VelocityNotification notification = new VelocityNotification(key, items, "templates/notifications/notification.module.to.parent.vm");
            notification.addToVelocityContext("moduleType", (Object)moduleType);
            notification.addToVelocityContext("displayPomFilePath", (Object)relativePomFilePath);
            notification.addToVelocityContext("artifactId", (Object)artifactId);
            this.addManualAction(pomFilePath, (Notification)notification);
        }
    }

    public void addNoticeToAddDependency(GenerationContext context, String artifactId, String persistType) {
        String pomFilePath = context.getProjectDirectory() + File.separator + artifactId + File.separator + "pom.xml";
        boolean alreadyExists = this.existsInFile(pomFilePath, String.format("extensions-data-delivery-spark-%s", persistType));
        if (!alreadyExists) {
            String relativePomFilePath = this.getRelativePathToProjectRoot(context.getExecutionRootDirectory(), new File(pomFilePath));
            String key = this.getMessageKey(relativePomFilePath, "extensions-data-delivery-spark", persistType);
            VelocityNotification notification = new VelocityNotification(key, new HashSet(), "templates/notifications/notification.dependency.vm");
            notification.addToVelocityContext("dependencyArtifactId", (Object)String.format("extensions-data-delivery-spark-%s", persistType));
            notification.addToVelocityContext("artifactId", (Object)artifactId);
            this.addManualAction(pomFilePath, (Notification)notification);
        }
    }

    public void addDockerBuildWithLiveUpdateTiltFileMessage(GenerationContext context, String dockerArtifactId, String dockerApplicationArtifactId, String pipelineName, String stepName, boolean includeHelmBuild) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual Dockerbuild updates to Tiltfile");
        } else {
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            String pipelineArtifactId = dockerArtifactId.replace("-docker", "-pipelines");
            String stepNameSnakeCase = PipelineUtils.deriveLowerSnakeCaseNameFromHyphenatedString(stepName);
            boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, dockerApplicationArtifactId);
            if (!tiltFileContainsArtifact && this.showWarnings(tiltFilePath)) {
                String key = this.getMessageKey("Tiltfile", "docker-build", dockerApplicationArtifactId);
                this.addLocalResourceTiltFileMessage(context, dockerArtifactId, dockerApplicationArtifactId, stepName, pipelineName + "/" + stepName, true);
                VelocityNotification notification = new VelocityNotification(key, new HashSet(), "templates/notifications/notification.docker.live.vm");
                notification.addToVelocityContext("dockerApplicationArtifactId", (Object)dockerApplicationArtifactId);
                notification.addToVelocityContext("stepName", (Object)stepName);
                notification.addToVelocityContext("pipelineArtifactId", (Object)pipelineArtifactId);
                notification.addToVelocityContext("pipelineName", (Object)pipelineName);
                notification.addToVelocityContext("dockerArtifactId", (Object)dockerArtifactId);
                notification.addToVelocityContext("referenceName", (Object)dockerApplicationArtifactId);
                notification.addToVelocityContext("stepNameSnakeCase", (Object)stepNameSnakeCase);
                notification.addToVelocityContext("includeHelmBuild", (Object)includeHelmBuild);
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    public void addDockerBuildTiltFileMessage(DockerBuildParams params) {
        File rootDir = params.getContext().getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual Dockerbuild updates to Tiltfile");
        } else {
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            String deployArtifactId = params.getDockerArtifactId().replace("-docker", "-deploy");
            boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, params.getDockerApplicationArtifactId());
            if (!tiltFileContainsArtifact && this.showWarnings(tiltFilePath)) {
                String key = this.getMessageKey("Tilefile", "docker-build", params.getDockerApplicationArtifactId());
                VelocityNotification notification = new VelocityNotification(key, GROUP_TILT, new HashSet(), "templates/notifications/notification.docker.tilt.vm");
                notification.addToVelocityContext("appNameTitle", (Object)params.getAppName());
                notification.addToVelocityContext("dockerArtifactId", (Object)params.getDockerArtifactId());
                notification.addToVelocityContext("dockerApplicationArtifactId", (Object)params.getDockerApplicationArtifactId());
                notification.addToVelocityContext("includeHelmBuild", (Object)params.isIncludeHelmBuild());
                notification.addToVelocityContext("appName", (Object)params.getDeployedAppName());
                notification.addToVelocityContext("deployArtifactId", (Object)deployArtifactId);
                notification.addToVelocityContext("includeLatestTag", (Object)params.isIncludeLatestTag());
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    public void addHabushuRegexPluginInvocation(GenerationContext context) {
        if (!this.existsInFile("pom.xml", "<id>set-habushu-dist-artifact-version</id>")) {
            VelocityNotification notification = new VelocityNotification(this.getMessageKey("pom.xml", "set-habushu-dist-artifact-version"), "root-plugins", new HashSet(), "templates/notifications/notification.root.habushu.regex.plugin.vm");
            this.addManualAction(context.getRootArtifactId(), (Notification)notification);
        }
    }

    public void addCleanPluginNotification(String deployArtifactId, GenerationContext context) {
        File rootDir = context.getExecutionRootDirectory();
        String deployPom = rootDir.getAbsolutePath() + File.separator + deployArtifactId + File.separator + "pom.xml";
        if (deployArtifactId != null && !this.existsInFile(deployPom, "<artifactId>maven-clean-plugin</artifactId>")) {
            String relativePomFilePath = this.getRelativePathToProjectRoot(rootDir, new File(deployPom));
            VelocityNotification notification = new VelocityNotification(this.getMessageKey(relativePomFilePath, "clean-deploy-apps-targets"), "deploy-plugins", new HashSet(), "templates/notifications/notification.deploy.clean.app.target.vm");
            this.addManualAction(deployPom, (Notification)notification);
        }
    }

    public void addPipelineInvocationServiceDeployment(GenerationContext context) {
        File rootDir = context.getExecutionRootDirectory();
        String deployArtifactId = MavenUtil.getDeployModuleName(rootDir);
        String deployPom = rootDir.getAbsolutePath() + File.separator + deployArtifactId + File.separator + "pom.xml";
        if (deployArtifactId != null && !this.existsInFile(deployPom, "<artifactId>mda-maven-plugin</artifactId>")) {
            String relativePomFilePath = this.getRelativePathToProjectRoot(rootDir, new File(deployPom));
            VelocityNotification notification = new VelocityNotification(this.getMessageKey(relativePomFilePath, "pipeline-invocation-service-spark-apps"), "deploy-plugins", new HashSet(), "templates/notifications/notification.mda.maven.pipeline.invocation.execution.vm");
            notification.addToExternalVelocityContextProperties("deployArtifactId", deployArtifactId);
            this.addManualAction(deployPom, (Notification)notification);
            this.addDeployPomMessage(context, "pipeline-invocation-service-v2", "pipeline-invocation-service");
        }
        this.addCleanPluginNotification(deployArtifactId, context);
        this.addHabushuRegexPluginInvocation(context);
    }

    public void addLocalResourceTiltFileMessage(GenerationContext context, String dockerArtifactId, String dockerApplicationArtifactId, String moduleName, String pipelinesModulePath, boolean copyFullPath) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual Dockerbuild updates to Tiltfile");
        } else {
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            String pipelinesArtifactId = dockerArtifactId.replace("-docker", "-pipelines");
            boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, "compile-" + moduleName);
            if (!tiltFileContainsArtifact && this.showWarnings(tiltFilePath)) {
                String key = this.getMessageKey("Tiltfile", "local-resource", moduleName);
                VelocityNotification notification = new VelocityNotification(key, new HashSet(), "templates/notifications/notification.local.resource.tilt.vm");
                notification.addToVelocityContext("srcModuleName", (Object)moduleName);
                notification.addToVelocityContext("srcModulePath", (Object)(pipelinesArtifactId + "/" + pipelinesModulePath));
                notification.addToVelocityContext("dockerModulePath", (Object)(dockerArtifactId + "/" + dockerApplicationArtifactId));
                notification.addToVelocityContext("copyFullPath", (Object)copyFullPath);
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    public void addSparkWorkerDockerBuildTiltMessage(GenerationContext context, String appName, String dockerApplicationArtifactId, String dockerArtifactId) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual Spark Worker resources to Tiltfile");
        } else {
            DockerBuildParams params = new DockerBuildParams.ParamBuilder().setContext(context).setAppName(appName).setDockerApplicationArtifactId(dockerApplicationArtifactId).setDockerArtifactId(dockerArtifactId).setIncludeHelmBuild(false).setIncludeLatestTag(true).build();
            this.addDockerBuildTiltFileMessage(params);
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            String text = "k8s_kind('SparkApplication'";
            boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, "k8s_kind('SparkApplication'");
            if (!tiltFileContainsArtifact && this.showWarnings(tiltFilePath)) {
                String key = this.getMessageKey("Tiltfile", "spark-worker-docker-build");
                VelocityNotification notification = new VelocityNotification(key, GROUP_TILT, new HashSet(), "templates/notifications/notification.spark.worker.docker.build.tilt.vm");
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    public void addHelmTiltFileMessage(GenerationContext context, String appName, String deployArtifactId) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual Helm updates to for Tiltfile");
        } else {
            String text;
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, text = "apps/" + appName + "'");
            if (!tiltFileContainsArtifact && this.showWarnings(tiltFilePath)) {
                String key = this.getMessageKey("Tiltfile", "helm", appName);
                VelocityNotification notification = new VelocityNotification(key, GROUP_TILT, new HashSet(), "templates/notifications/notification.helm.tilt.vm");
                notification.addToVelocityContext("appName", (Object)appName);
                notification.addToVelocityContext("deployArtifactId", (Object)deployArtifactId);
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    public void addResourceDependenciesTiltFileMessage(GenerationContext context, String appName, List<String> appDependencies) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual resource dependency updates to for Tiltfile");
        } else {
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            StringBuilder item = new StringBuilder();
            String formattedAppDependencies = appDependencies.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
            item.append(String.format("k8s_resource('%s', resource_deps=[%s])\n\n", appName, formattedAppDependencies));
            boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, item.toString().trim());
            if (!tiltFileContainsArtifact && this.showWarnings(tiltFilePath)) {
                String key = this.getMessageKey("Tiltfile", "resource-dependencies", appName);
                VelocityNotification notification = new VelocityNotification(key, new HashSet(), "templates/notifications/notification.resource.tilt.vm");
                notification.addToVelocityContext("appName", (Object)appName);
                notification.addToVelocityContext("formattedAppDependencies", (Object)formattedAppDependencies);
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    private void appendTiltHelmBuild(String appName, String deployArtifactId, StringBuilder builder) {
        builder.append("yaml = helm(\n");
        builder.append("   '").append(deployArtifactId).append("/src/main/resources/apps/").append(appName).append("',\n");
        builder.append("   values=['").append(deployArtifactId).append("/src/main/resources/apps/").append(appName).append("/values.yaml',\n");
        builder.append("       '").append(deployArtifactId).append("/src/main/resources/apps/").append(appName).append("/values-dev.yaml']\n");
        builder.append(")\n");
        builder.append("k8s_yaml(yaml)\n");
        builder.append(EMPTY_LINE);
    }

    public void addYamlTiltFileMessage(GenerationContext context, String appName, String deployArtifactId, String yamlFileName) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual Helm updates to for Tiltfile");
        } else {
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            String yamlFilePath = deployArtifactId + "/src/main/resources/apps/" + appName + "/" + yamlFileName;
            String text = "apps/" + appName;
            boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, text);
            if (!tiltFileContainsArtifact && this.showWarnings(tiltFilePath)) {
                String key = this.getMessageKey("Tiltfile", "yaml", appName);
                HashSet<CallSite> items = new HashSet<CallSite>();
                items.add((CallSite)((Object)yamlFilePath));
                VelocityNotification notification = new VelocityNotification(key, GROUP_TILT, items, "templates/notifications/notification.yaml.tiltfile.vm");
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    public void addElasticsearchTiltResources(GenerationContext context, String appName, String artifactId) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual Helm updates to for Tiltfile");
        } else {
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            String[] elasticSearchResources = new String[]{"k8s_kind('Elasticsearch')", "k8s_resource('elasticsearch')"};
            HashSet<String> items = new HashSet<String>();
            for (String resource : elasticSearchResources) {
                boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, resource);
                if (tiltFileContainsArtifact || !this.showWarnings(tiltFilePath)) continue;
                items.add(resource);
            }
            if (items.size() > 0) {
                String key = this.getMessageKey("Tiltfile", "elasticsearch");
                VelocityNotification notification = new VelocityNotification(key, GROUP_TILT, items, "templates/notifications/notification.elastic.search.tilt.vm");
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    public void addSparkWorkerTiltResources(GenerationContext context, String parentArtifactId, String pipelineArtifactId, String pipelineImplementation) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.tiltFileFound(rootDir)) {
            logger.warn("Unable to find Tiltfile. Will not be able to direct manual Spark Worker resources to Tiltfile");
        } else {
            String text;
            String tiltFilePath = rootDir.getAbsolutePath() + File.separator + "Tiltfile";
            boolean tiltFileContainsArtifact = this.existsInFile(tiltFilePath, text = "--values " + parentArtifactId + "/" + pipelineArtifactId);
            if (!tiltFileContainsArtifact && this.showWarnings(tiltFilePath)) {
                String key = this.getMessageKey("Tiltfile", "spark-application");
                VelocityNotification notification = new VelocityNotification(key, GROUP_TILT, new HashSet(), "templates/notifications/notification.spark.worker.tilt.vm");
                notification.addToVelocityContext("parentArtifactId", (Object)parentArtifactId);
                notification.addToVelocityContext("pipelineArtifactId", (Object)pipelineArtifactId);
                notification.addToVelocityContext("pipelineImplementation", (Object)pipelineImplementation);
                notification.addToVelocityContext("pythonPipelineArtifactId", (Object)PipelineUtils.deriveLowerSnakeCaseNameFromHyphenatedString(pipelineArtifactId));
                notification.addToVelocityContext("aissembleVersion", (Object)PipelineUtils.getAiSSEMBLEVersion(context));
                this.addManualAction(tiltFilePath, (Notification)notification);
            }
        }
    }

    public void addDeployPomMessage(GenerationContext context, String profile, String appName) {
        this.addDeployPomMessage(context, profile, appName, null);
    }

    public void addDeployPomMessage(GenerationContext context, String profile, String appName, List<String> appDependencies) {
        File rootDir = context.getExecutionRootDirectory();
        if (!rootDir.exists() || !this.deployModuleFoundPom(rootDir)) {
            logger.warn("Unable to find Docker module. Will not be able to direct manual updates for the deploy module's POM.xml");
        } else if (StringUtils.isNotEmpty((String)profile)) {
            boolean hasAppDependencies;
            NotificationParams params = this.configureNotification(rootDir, profile, appName, MavenUtil::getDeployModuleName);
            boolean bl = hasAppDependencies = appDependencies != null;
            if (!params.isExistsInFileOrNotification()) {
                VelocityNotification notification = new VelocityNotification(params.getKey(), "deploypom", new HashSet(), "templates/notifications/notification.deploy.pom.vm");
                notification.addToVelocityContext("appName", (Object)appName);
                notification.addToVelocityContext("profile", (Object)profile);
                notification.addToVelocityContext("basePackage", (Object)context.getBasePackage());
                notification.addToVelocityContext("profileConfiguration", (Object)params.getProfileConfiguration());
                notification.addToVelocityContext("hasAppDependencies", (Object)hasAppDependencies);
                notification.addToVelocityContext("appDependencies", appDependencies);
                notification.addToExternalVelocityContextProperties("deployArtifactId", params.getArtifactId());
                this.addManualAction(params.getPomFilePath(), (Notification)notification);
            } else if (hasAppDependencies && !this.propertyVariableExistsInPomFile(params.getPomFile(), appName, "appDependencies", String.join((CharSequence)",", appDependencies))) {
                params.setKey(this.getMessageKey(params.getPomFilePath(), "execution", "appDependencies", appName));
                VelocityNotification notification = new VelocityNotification(params.getKey(), new HashSet(), "templates/notifications/notification.deploy.pom.property.variables.vm");
                notification.addToVelocityContext("profile", (Object)profile);
                notification.addToVelocityContext("deployArtifactId", (Object)params.getArtifactId());
                notification.addToVelocityContext("appDependencies", appDependencies);
                this.addManualAction(params.getPomFilePath(), (Notification)notification);
            }
        }
    }

    public void addDockerPomMessage(GenerationContext context, String profile, String artifactId) {
        File optionalRoot = context.getExecutionRootDirectory();
        if (!optionalRoot.exists() || !this.dockerModuleFoundPom(optionalRoot)) {
            logger.warn("Unable to find Docker module. Will not be able to direct manual updates for the deploy module's POM.xml");
        } else {
            NotificationParams params = this.configureNotification(optionalRoot, profile, artifactId, MavenUtil::getDockerModuleName);
            if (StringUtils.isNotEmpty((String)profile) && !params.isExistsInFileOrNotification()) {
                VelocityNotification notification = new VelocityNotification(params.getKey(), "dockerpom", new HashSet(), "templates/notifications/notification.docker.pom.vm");
                notification.addToVelocityContext("profile", (Object)profile);
                notification.addToVelocityContext("appName", (Object)artifactId);
                notification.addToVelocityContext("basePackage", (Object)context.getBasePackage());
                notification.addToVelocityContext("profileConfiguration", (Object)params.getProfileConfiguration());
                notification.addToExternalVelocityContextProperties("dockerArtifactId", params.getArtifactId());
                this.addManualAction(params.getPomFilePath(), (Notification)notification);
            }
        }
    }

    private boolean executionAppExistsInPomFile(File file, String appName) {
        return this.propertyVariableExistsInPomFile(file, appName, "appName", appName);
    }

    private boolean propertyVariableExistsInPomFile(File file, String appName, String propertyVariableName, String propertyVariableValue) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        boolean exists = false;
        if (file.exists() && !file.isDirectory()) {
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(file);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String expression = "/project/build/plugins/plugin/executions/execution";
                NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node pvNode;
                    Node appNode;
                    Node nNode = nodeList.item(i);
                    if (nNode.getNodeType() != 1) continue;
                    Node cNode = this.getChildNodeByName(nNode, "configuration");
                    if ((cNode = this.getChildNodeByName(cNode, "propertyVariables")) == null || (appNode = this.getChildNodeByName(cNode, "appName")) == null || !appName.equals(appNode.getTextContent()) || (pvNode = this.getChildNodeByName(cNode, propertyVariableName)) == null || !propertyVariableValue.equals(pvNode.getTextContent())) continue;
                    exists = true;
                }
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                logger.error("Error while trying to find propertyVariable {} for appName {}", new Object[]{propertyVariableName, appName, e});
            }
        }
        return exists;
    }

    private Node getChildNodeByName(Node nNode, String name) {
        Element eElement = (Element)nNode;
        if (eElement != null) {
            return eElement.getElementsByTagName(name).item(0);
        }
        return null;
    }

    public void addNoticeToAddPythonDependencies(GenerationContext context, Set<String> dependencies, String description) {
        String pyprojectFilePath = context.getProjectDirectory() + File.separator + "pyproject.toml";
        LinkedHashSet<String> dependenciesToAdd = new LinkedHashSet<String>();
        for (String dependency : dependencies) {
            if (this.existsInFile(pyprojectFilePath, dependency)) continue;
            dependenciesToAdd.add(dependency);
        }
        if (CollectionUtils.isNotEmpty(dependenciesToAdd)) {
            String relativePyprojectFilePath = this.getRelativePathToProjectRoot(context.getExecutionRootDirectory(), context.getProjectDirectory()) + File.separator + "pyproject.toml";
            String key = this.getMessageKey(relativePyprojectFilePath, "requirement", context.getArtifactId());
            HashSet<String> items = new HashSet<String>();
            for (String dependency : dependenciesToAdd) {
                items.add(dependency);
            }
            VelocityNotification notification = new VelocityNotification(key, items, "templates/notifications/notification.python.dependencies.vm");
            notification.addToVelocityContext("description", (Object)description);
            notification.addToVelocityContext("artifactId", (Object)context.getArtifactId());
            this.addManualAction(pyprojectFilePath, (Notification)notification);
        }
    }

    public void addNoticeToUpdateS3LocalConfig(GenerationContext context, String bucketName, List<String> objectNames) {
        File rootDir = context.getExecutionRootDirectory();
        if (rootDir.exists() && this.deployModuleFoundPom(rootDir)) {
            Path rootPath = rootDir.toPath();
            Path s3ValuesPath = rootPath.resolve(Paths.get(MavenUtil.getDeployModuleName(rootDir), "src", "main", "resources", "apps", "s3-local", "values.yaml")).toAbsolutePath().normalize();
            try {
                if (this.showWarnings(s3ValuesPath.toString())) {
                    String relativeValuesFilePath = this.getRelativePathToProjectRoot(rootDir, s3ValuesPath.toFile());
                    if (!this.existsInFile(s3ValuesPath.toString(), "- name: " + bucketName)) {
                        HashSet<String> items = new HashSet<String>();
                        for (String objectName : objectNames) {
                            items.add(objectName);
                        }
                        String key = this.getMessageKey(relativeValuesFilePath, "buckets", bucketName);
                        VelocityNotification notification = new VelocityNotification(key, items, "templates/notifications/notification.s3.local.buckets.vm");
                        notification.addToVelocityContext("rootPath", (Object)rootPath.relativize(s3ValuesPath).toString());
                        notification.addToVelocityContext("bucketName", (Object)bucketName);
                        this.addManualAction(s3ValuesPath.toString(), (Notification)notification);
                    } else {
                        HashSet<String> items = new HashSet<String>();
                        boolean pathExistsInFile = false;
                        for (String objectName : objectNames) {
                            if (this.existsInFile(s3ValuesPath.toString(), "- " + objectName)) continue;
                            items.add(objectName);
                            pathExistsInFile = true;
                        }
                        if (pathExistsInFile) {
                            String key = this.getMessageKey(relativeValuesFilePath, "bucketobjects", bucketName);
                            VelocityNotification notification = new VelocityNotification(key, items, "templates/notifications/notification.s3.local.bucketobjects.vm");
                            notification.addToVelocityContext("rootPath", (Object)rootPath.relativize(s3ValuesPath).toString());
                            notification.addToVelocityContext("bucketName", (Object)bucketName);
                            this.addManualAction(s3ValuesPath.toString(), (Notification)notification);
                        }
                    }
                }
            }
            catch (GenerationException e) {
                logger.warn("Failed to validate s3-local buckets and objects. Check that the {} file exists", (Object)s3ValuesPath);
            }
        }
    }

    public void addNoticeToUpdateKafkaConfig(GenerationContext context, String topicName) {
        File rootDir = context.getExecutionRootDirectory();
        if (rootDir.exists() && this.deployModuleFoundPom(rootDir)) {
            Path rootPath = rootDir.toPath();
            Path kafkaValuesPath = rootPath.resolve(Paths.get(rootPath.getFileName() + "-deploy", "src", "main", "resources", "apps", "kafka-cluster", "values.yaml")).toAbsolutePath().normalize();
            try {
                if (this.showWarnings(kafkaValuesPath.toString()) && !this.existsInFile(kafkaValuesPath.toString(), topicName + ":") && this.existsInFile(kafkaValuesPath.toString(), "KAFKA_CREATE_TOPICS")) {
                    String relativeValuesFilePath = this.getRelativePathToProjectRoot(rootDir, kafkaValuesPath.toFile());
                    String key = this.getMessageKey(relativeValuesFilePath, "kafka-topics");
                    HashSet<String> items = new HashSet<String>();
                    items.add(topicName);
                    VelocityNotification notification = new VelocityNotification(key, items, "templates/notifications/notification.kafka.config.vm");
                    notification.addToVelocityContext("rootPath", (Object)rootPath.relativize(kafkaValuesPath).toString());
                    this.addManualAction(kafkaValuesPath.toString(), (Notification)notification);
                }
            }
            catch (GenerationException e) {
                logger.warn("Failed to validate Kafka topics. Check that the {} file exists", (Object)kafkaValuesPath);
            }
        }
    }

    private boolean showWarnings(String filePath) {
        return !this.existsInFile(filePath, SUPPRESS_WARNINGS);
    }

    private boolean existsInFile(String filePath, String text) {
        boolean bl;
        block8: {
            Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]));
            try {
                bl = stream.anyMatch(lines -> lines.contains(text));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GenerationException("Could not introspect file: " + filePath, (Throwable)e);
                }
            }
            stream.close();
        }
        return bl;
    }

    private String getRelativePathToProjectRoot(File projectRoot, File currentDirectory) {
        return projectRoot.toPath().relativize(currentDirectory.toPath()).toString();
    }

    private String getMessageKey(String ... keyComponents) {
        if (keyComponents.length > 0) {
            return String.join((CharSequence)"_", keyComponents);
        }
        return "";
    }

    private boolean moduleFoundPom(File rootProjectDirectory, String moduleName) {
        return moduleName != null && MavenUtil.fileExists(rootProjectDirectory, moduleName);
    }

    private boolean deployModuleFoundPom(File rootProjectDirectory) {
        return this.moduleFoundPom(rootProjectDirectory, MavenUtil.getDeployModuleName(rootProjectDirectory));
    }

    private boolean dockerModuleFoundPom(File rootProjectDirectory) {
        return this.moduleFoundPom(rootProjectDirectory, MavenUtil.getDockerModuleName(rootProjectDirectory));
    }

    private boolean tiltFileFound(File rootProjectDirectory) {
        return MavenUtil.fileExists(rootProjectDirectory, "Tiltfile");
    }

    private void addManualAction(String file, Notification notification) {
        NotificationCollector.addNotification((String)file, (Notification)notification);
    }

    public boolean hasNotificationWithAppName(String file, String key, String appName) {
        Map notificationsForFile = NotificationCollector.getNotifications().computeIfAbsent(file, m -> new ConcurrentHashMap());
        boolean found = false;
        if (notificationsForFile.containsKey(key)) {
            Set items = ((Notification)notificationsForFile.get(key)).getItems();
            for (String item : items) {
                if (!item.contains("<appName>" + appName + "</appName>")) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private final boolean executionAppExistsInNotification(String file, String key, String appName) {
        return this.hasNotificationWithAppName(file, key, appName);
    }

    private NotificationParams configureNotification(File rootDir, String profile, String appName, Function<File, String> getModule) {
        NotificationParams params = new NotificationParams();
        params.setArtifactId(getModule.apply(rootDir));
        String deployDir = rootDir.getAbsolutePath() + File.separator + params.getArtifactId();
        params.setPomFilePath(deployDir + File.separator + "pom.xml");
        params.setProfileConfiguration("<profile>" + profile + "</profile>");
        params.setPomFile(new File(params.getPomFilePath()));
        String relativePomFilePath = this.getRelativePathToProjectRoot(rootDir, params.getPomFile());
        params.setKey(this.getMessageKey(relativePomFilePath, "execution", appName));
        params.setExistsInFileOrNotification(this.executionAppExistsInPomFile(params.getPomFile(), appName) || this.executionAppExistsInNotification(params.getPomFilePath(), params.getKey(), appName));
        return params;
    }

    private class NotificationParams {
        private String artifactId;
        private String pomFilePath;
        private String profileConfiguration;
        private File pomFile;
        private String key;
        private boolean existsInFileOrNotification;

        private NotificationParams() {
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getPomFilePath() {
            return this.pomFilePath;
        }

        public void setPomFilePath(String pomFilePath) {
            this.pomFilePath = pomFilePath;
        }

        public String getProfileConfiguration() {
            return this.profileConfiguration;
        }

        public void setProfileConfiguration(String profileConfiguration) {
            this.profileConfiguration = profileConfiguration;
        }

        public File getPomFile() {
            return this.pomFile;
        }

        public void setPomFile(File pomFile) {
            this.pomFile = pomFile;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public boolean isExistsInFileOrNotification() {
            return this.existsInFileOrNotification;
        }

        public void setExistsInFileOrNotification(boolean existsInFileOrNotification) {
            this.existsInFileOrNotification = existsInFileOrNotification;
        }
    }
}

