/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.ManualActionNotificationService;
import com.boozallen.aiops.mda.generator.AbstractResourcesGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public abstract class AbstractKubernetesGenerator
extends AbstractResourcesGenerator {
    protected static final String APP_NAME = "appName";
    protected static final String APP_DEPENDENCIES = "appDependencies";
    protected static final String AISSEMBLE_VERSION = "aissembleVersion";
    protected static final String VERSION = "version";
    protected static final String DOCKER_PROJECT_REPOSITORY_URL = "dockerProjectRepositoryUrl";

    protected VelocityContext configureWithoutGeneration(GenerationContext generationContext) {
        String appDependencies;
        VelocityContext vc = this.getNewVelocityContext(generationContext);
        String appName = (String)generationContext.getPropertyVariables().get(APP_NAME);
        String aissembleVersion = (String)generationContext.getPropertyVariables().get(AISSEMBLE_VERSION);
        String dockerProjectRepositoryUrl = (String)generationContext.getPropertyVariables().get(DOCKER_PROJECT_REPOSITORY_URL);
        if (StringUtils.isEmpty((CharSequence)appName)) {
            appName = generationContext.getArtifactId();
        }
        String projectName = generationContext.getRootArtifactId();
        String version = generationContext.getVersion();
        vc.put(APP_NAME, (Object)appName);
        vc.put("projectName", (Object)projectName);
        vc.put("versionTag", (Object)aissembleVersion);
        vc.put(VERSION, (Object)version);
        vc.put(DOCKER_PROJECT_REPOSITORY_URL, (Object)dockerProjectRepositoryUrl);
        String updatedOutputFile = this.replace(APP_NAME, generationContext.getOutputFile(), appName);
        generationContext.setOutputFile(updatedOutputFile);
        String updatedOutputFile2 = this.replace(VERSION, generationContext.getOutputFile(), version);
        generationContext.setOutputFile(updatedOutputFile2);
        ManualActionNotificationService manualActionNotificationService = this.getNotificationService();
        String deployArtifactId = generationContext.getArtifactId();
        if (!"configuration-store".equals(appName)) {
            this.addTiltNotification(generationContext, appName, deployArtifactId);
        }
        if (!StringUtils.isEmpty((CharSequence)(appDependencies = (String)generationContext.getPropertyVariables().get(APP_DEPENDENCIES)))) {
            List<String> appDependencyList = Arrays.stream(appDependencies.split(",")).map(String::trim).collect(Collectors.toList());
            manualActionNotificationService.addResourceDependenciesTiltFileMessage(generationContext, appName, appDependencyList);
        }
        return vc;
    }

    protected ManualActionNotificationService getNotificationService() {
        return new ManualActionNotificationService();
    }

    protected void addTiltNotification(GenerationContext generationContext, String appName, String deployArtifactId) {
        this.getNotificationService().addHelmTiltFileMessage(generationContext, appName, deployArtifactId);
    }

    public void generate(GenerationContext context) {
        VelocityContext vc = this.configureWithoutGeneration(context);
        this.generateFile(context, vc);
    }
}

