/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractResourcesGenerator;
import com.boozallen.aiops.mda.generator.common.PipelineEnum;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.BasePipelineDecorator;
import com.boozallen.aiops.mda.metamodel.element.BaseStepDecorator;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public abstract class AbstractLineageResourcesGenerator
extends AbstractResourcesGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLineageResourcesGenerator.class);
    private PipelineEnum pipelineType;

    public void setPipelineType(PipelineEnum pipelineEnum) {
        this.pipelineType = pipelineEnum;
    }

    public void generate(GenerationContext generationContext) {
        VelocityContext vc = this.getNewVelocityContext(generationContext);
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(pipelineMap.values());
        HashMap lineageStepsByPipeline = new HashMap();
        boolean lineageEnabled = false;
        for (Pipeline pipeline : pipelines) {
            BasePipelineDecorator decorated = new BasePipelineDecorator(pipeline);
            if (!pipeline.getType().getName().equals(PipelineEnum.getPipelineType(this.pipelineType)) || !pipeline.getDataLineage() && !decorated.isModelLineageSupportNeeded()) continue;
            lineageEnabled = true;
            ArrayList<String> lineageSteps = new ArrayList<String>();
            for (BaseStepDecorator step : decorated.getSteps()) {
                if (!decorated.getDataLineage() && !step.isModelLineageEnabled()) continue;
                lineageSteps.add(PipelineUtils.getQualifiedPipelineStepName(pipeline, step));
            }
            lineageStepsByPipeline.putIfAbsent(pipeline.getName(), lineageSteps);
        }
        MavenProject project = this.readPom(generationContext.getExecutionRootDirectory());
        vc.put("scmUrl", (Object)project.getScm().getUrl());
        if (lineageEnabled) {
            vc.put("dataLineageStepsByPipeline", lineageStepsByPipeline);
            String fileName = generationContext.getOutputFile();
            generationContext.setOutputFile(fileName);
            this.generateFile(generationContext, vc);
        }
    }

    private MavenProject readPom(File rootDirectory) {
        File pomFile = Paths.get(rootDirectory.getAbsolutePath(), "pom.xml").toFile();
        Model model = null;
        FileReader reader = null;
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        try {
            reader = new FileReader(pomFile);
            model = mavenreader.read((Reader)reader);
            model.setPomFile(pomFile);
        }
        catch (Exception ex) {
            logger.error("Encountered error parsing root pom file: " + ex.getMessage());
            throw new RuntimeException(ex.getCause());
        }
        return new MavenProject(model);
    }
}

