/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.ManualActionNotificationService;
import com.boozallen.aiops.mda.generator.common.AbstractGeneratorAissemble;
import com.boozallen.aiops.mda.generator.util.MavenUtil;
import com.boozallen.aiops.mda.generator.util.SemanticDataUtil;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public abstract class AbstractMavenModuleGenerator
extends AbstractGeneratorAissemble {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMavenModuleGenerator.class);
    protected ManualActionNotificationService manualActionNotificationService = new ManualActionNotificationService();

    protected String deriveDescriptiveNameFromCamelCase(String camelCasedString) {
        StringBuilder artifactId = new StringBuilder();
        String[] splitStrings = StringUtils.splitByCharacterTypeCamelCase((String)camelCasedString);
        boolean isFirst = true;
        for (String segment : splitStrings) {
            if (isFirst) {
                isFirst = false;
            } else {
                artifactId.append(' ');
            }
            artifactId.append(StringUtils.capitalize((String)segment));
        }
        return artifactId.toString();
    }

    protected void addBuildNotices(GenerationContext context, String moduleArtifactId, String appName) {
        this.manualActionNotificationService.addNoticeToAddModuleToParentBuild(context, moduleArtifactId, appName);
    }

    protected String getModuleArtifactId(GenerationContext context, String appName) {
        String parentArtifactId = context.getArtifactId();
        return parentArtifactId.replace("pipelines", appName);
    }

    protected String getOutputSubFolder() {
        return "";
    }

    protected File getBaseFile(GenerationContext context) {
        return context.getProjectDirectory();
    }

    protected String getJavaDataRecordModule(GenerationContext context, SemanticDataUtil.DataRecordModule dataModule) {
        return MavenUtil.getDataRecordModuleName(context, this.metadataContext, MavenUtil.Language.JAVA, dataModule);
    }

    protected String getPythonDataRecordModule(GenerationContext context, SemanticDataUtil.DataRecordModule dataModule) {
        return MavenUtil.getDataRecordModuleName(context, this.metadataContext, MavenUtil.Language.PYTHON, dataModule);
    }
}

