/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.DockerBuildParams;
import com.boozallen.aiops.mda.generator.AbstractMavenModuleGenerator;
import com.boozallen.aiops.mda.generator.common.DataFlowStrategy;
import com.boozallen.aiops.mda.generator.common.MachineLearningStrategy;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.ArrayList;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class AirflowDockerPomGenerator
extends AbstractMavenModuleGenerator {
    private static final String MODULE_ARTIFACT_ID = "moduleArtifactId";

    public void generate(GenerationContext context) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
        String basefileName = context.getOutputFile();
        basefileName = this.replaceBasePackage(basefileName, context.getBasePackageAsPath());
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(pipelineMap.values());
        DataFlowStrategy dataFlowStrategy = new DataFlowStrategy(pipelines);
        MachineLearningStrategy mlStrategy = new MachineLearningStrategy(pipelines);
        if (mlStrategy.isAirflowNeeded() || dataFlowStrategy.isAirflowNeeded()) {
            VelocityContext vc = new VelocityContext();
            String rootArtifactId = context.getRootArtifactId();
            String airflowDockerArtifactId = context.getArtifactId().replace("-docker", "-airflow-docker");
            vc.put("rootArtifactId", (Object)rootArtifactId);
            vc.put("artifactId", (Object)airflowDockerArtifactId);
            vc.put("groupId", (Object)context.getGroupId());
            vc.put("parentArtifactId", (Object)context.getArtifactId());
            vc.put("version", (Object)context.getVersion());
            vc.put("parentDescriptiveName", (Object)context.getDescriptiveName());
            vc.put("trainingPipelines", mlStrategy.getSteps());
            vc.put("sparkPipelines", dataFlowStrategy.getSparkPipelines());
            vc.put("pysparkPipelines", dataFlowStrategy.getPySparkPipelines());
            vc.put("enablePySparkSupport", (Object)dataFlowStrategy.isPySparkSupportNeeded());
            vc.put("enableDeltaSupport", (Object)dataFlowStrategy.isDeltaSupportNeeded());
            vc.put("enableHiveSupport", (Object)dataFlowStrategy.isHiveSupportNeeded());
            vc.put("enablePostgresSupport", (Object)dataFlowStrategy.isPostgresSupportNeeded());
            vc.put("enableRDBMSSupport", (Object)dataFlowStrategy.isRdbmsSupportNeeded());
            vc.put("enableElasticsearchSupport", (Object)dataFlowStrategy.isElasticsearchSupportNeeded());
            vc.put("enableNeo4jSupport", (Object)dataFlowStrategy.isNeo4jSupportNeeded());
            vc.put("dataFlowPipelines", dataFlowStrategy.getDataFlowPipelinesRequiringAirflow());
            String fileName = this.replace(MODULE_ARTIFACT_ID, basefileName, airflowDockerArtifactId);
            context.setOutputFile(fileName);
            this.generateFile(context, vc);
            this.manualActionNotificationService.addNoticeToAddModuleToParentBuild(context, airflowDockerArtifactId, "docker");
            DockerBuildParams params = new DockerBuildParams.ParamBuilder().setContext(context).setAppName("airflow").setDockerApplicationArtifactId(airflowDockerArtifactId).setDockerArtifactId(context.getArtifactId()).setIncludeLatestTag(true).build();
            this.manualActionNotificationService.addDockerBuildTiltFileMessage(params);
            this.manualActionNotificationService.addDeployPomMessage(context, "airflow-deploy-v2", "airflow");
            this.manualActionNotificationService.addDeployPomMessage(context, "aissemble-shared-infrastructure-deploy", "shared-infrastructure");
        }
    }
}

