/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.common.AbstractGeneratorAissemble;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.generator.util.PythonGeneratorUtils;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.python.PythonPipeline;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.generator.GenerationException;

public abstract class BaseTargetedPipelineInferenceGenerator
extends AbstractGeneratorAissemble {
    public void generate(GenerationContext generationContext) {
        Pipeline pipeline = PipelineUtils.getTargetedPipeline(generationContext, this.metadataContext);
        PythonPipeline pythonTargetPipeline = new PythonPipeline(pipeline);
        String originalTemplateName = generationContext.getTemplateName();
        String pipelineImplementation = pipeline.getType().getImplementation();
        String pipelineSpecificTemplateName = this.replace("pipelineImplementation", originalTemplateName, pipelineImplementation);
        generationContext.setTemplateName(pipelineSpecificTemplateName);
        VelocityContext vc = this.getNewVelocityContext(generationContext);
        vc.put("pipeline", (Object)pythonTargetPipeline);
        List<Step> inferenceSteps = pythonTargetPipeline.getSteps().stream().filter(step -> "inference".equals(step.getType())).collect(Collectors.toList());
        List<? extends Step> decoratedInferenceSteps = this.decorateInferenceSteps(inferenceSteps);
        if (decoratedInferenceSteps.size() != 1) {
            throw new GenerationException(String.format("Currently the definition of only one inference step is supported - %s inference steps are defined in pipeline %s", decoratedInferenceSteps.size(), pipeline.getName()));
        }
        vc.put("step", (Object)decoratedInferenceSteps.get(0));
        String baseOutputFile = generationContext.getOutputFile();
        String artifactIdSnakeCase = PythonGeneratorUtils.normalizeToPythonCase(generationContext.getArtifactId());
        String fileName = this.replace("artifactIdSnakeCase", baseOutputFile, artifactIdSnakeCase);
        vc.put("artifactIdSnakeCase", (Object)artifactIdSnakeCase);
        generationContext.setOutputFile(fileName);
        this.generateFile(generationContext, vc);
    }

    protected abstract List<? extends Step> decorateInferenceSteps(List<Step> var1);

    protected File getBaseFile(GenerationContext generationContext) {
        return generationContext.getMainSourceDirectory();
    }
}

