/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractMavenModuleGenerator;
import com.boozallen.aiops.mda.generator.util.MavenUtil;
import com.boozallen.aiops.mda.generator.util.SemanticDataUtil;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public abstract class DataRecordsPomGenerator
extends AbstractMavenModuleGenerator {
    public void generate(GenerationContext context) {
        VelocityContext vc = this.getNewVelocityContext(context);
        String projectName = context.getRootArtifactId().replace("-shared", "");
        SemanticDataUtil.DataRecordModule generatingModule = this.getModuleBeingGenerated(context);
        String artifactId = MavenUtil.getDataRecordModuleName(context, this.metadataContext, this.getLanguage(), generatingModule);
        String fileName = artifactId + "/pom.xml";
        context.setOutputFile(fileName);
        vc.put("artifactId", (Object)artifactId);
        vc.put("basePackage", (Object)context.getBasePackage());
        vc.put("parentArtifactId", (Object)context.getArtifactId());
        vc.put("parentDescriptiveName", (Object)context.getDescriptiveName());
        vc.put("projectName", (Object)projectName);
        vc.put("javaDataRecords", (Object)this.getJavaDataRecordModule(context, SemanticDataUtil.DataRecordModule.CORE));
        vc.put("pythonDataRecords", (Object)this.getPythonDataRecordModule(context, SemanticDataUtil.DataRecordModule.CORE));
        this.populateVelocityContext(context, vc);
        if (this.shouldGenerate()) {
            this.generateFile(context, vc);
            this.manualActionNotificationService.addNoticeToAddModuleToParentBuild(context, artifactId, "shared");
        }
    }

    protected abstract boolean shouldGenerate();

    protected abstract void populateVelocityContext(GenerationContext var1, VelocityContext var2);

    protected abstract MavenUtil.Language getLanguage();

    private SemanticDataUtil.DataRecordModule getModuleBeingGenerated(GenerationContext context) {
        SemanticDataUtil.DataRecordModule generatingModule = null;
        String targetModuleBaseName = this.replace("project", context.getOutputFile(), "");
        targetModuleBaseName = this.replace("lang", targetModuleBaseName, "");
        targetModuleBaseName = targetModuleBaseName.replace("/pom.xml", "");
        for (SemanticDataUtil.DataRecordModule moduleType : SemanticDataUtil.DataRecordModule.values()) {
            if (!targetModuleBaseName.equals(moduleType.getBaseName())) continue;
            generatingModule = moduleType;
        }
        if (generatingModule == null) {
            throw new IllegalArgumentException("Could not determine the module type for the file: " + context.getOutputFile() + " [" + targetModuleBaseName + "]");
        }
        return generatingModule;
    }
}

