/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractResourcesGenerator;
import com.boozallen.aiops.mda.generator.common.DataFlowStrategy;
import com.boozallen.aiops.mda.generator.common.MachineLearningStrategy;
import com.boozallen.aiops.mda.generator.util.SemanticDataUtil;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class DockerGenerator
extends AbstractResourcesGenerator {
    public void generate(GenerationContext generationContext) {
        VelocityContext vc = this.getNewVelocityContext(generationContext);
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(pipelineMap.values());
        vc.put("pipelines", pipelines);
        DataFlowStrategy dataFlowStrategy = new DataFlowStrategy(pipelines);
        MachineLearningStrategy machineLearningStrategy = new MachineLearningStrategy(pipelines);
        vc.put("sparkPipelines", dataFlowStrategy.getSparkPipelines());
        vc.put("pysparkPipelines", dataFlowStrategy.getPySparkPipelines());
        vc.put("enablePySparkSupport", (Object)dataFlowStrategy.isPySparkSupportNeeded());
        vc.put("enableDeltaSupport", (Object)dataFlowStrategy.isDeltaSupportNeeded());
        vc.put("enableHiveSupport", (Object)dataFlowStrategy.isHiveSupportNeeded());
        boolean postgresSupportIsNeeded = dataFlowStrategy.isPostgresSupportNeeded() || machineLearningStrategy.isPostgresSupportNeeded();
        boolean rdbmsSupportIsNeeded = dataFlowStrategy.isRdbmsSupportNeeded() || machineLearningStrategy.isRdbmsSupportNeeded();
        vc.put("enablePostgresSupport", (Object)postgresSupportIsNeeded);
        vc.put("enableRDBMSSupport", (Object)rdbmsSupportIsNeeded);
        vc.put("enableElasticsearchSupport", (Object)dataFlowStrategy.isElasticsearchSupportNeeded());
        vc.put("enableNeo4jSupport", (Object)dataFlowStrategy.isNeo4jSupportNeeded());
        vc.put("enableSedonaSupport", (Object)dataFlowStrategy.isSedonaSupportNeeded());
        vc.put("enableDataLineageSupport", (Object)dataFlowStrategy.isDataLineageNeeded());
        vc.put("enableSemanticDataSupport", (Object)SemanticDataUtil.hasSemanticDataByContext(this.metadataContext));
        vc.put("trainingPipelines", machineLearningStrategy.getSteps());
        vc.put("dataFlowPipelines", dataFlowStrategy.getDataFlowPipelinesRequiringAirflow());
        String rootArtifactId = generationContext.getRootArtifactId();
        vc.put("rootArtifactId", (Object)rootArtifactId);
        if (this.shouldGenerate(pipelines)) {
            this.generateFile(generationContext, vc);
        }
    }

    protected boolean shouldGenerate(List<Pipeline> pipelines) {
        return true;
    }
}

