/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractMavenModuleGenerator;
import com.boozallen.aiops.mda.generator.MlflowDockerModuleGenerator;
import com.boozallen.aiops.mda.generator.common.MachineLearningStrategy;
import com.boozallen.aiops.mda.generator.common.PipelineStepPair;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class InferenceDockerModuleGenerator
extends AbstractMavenModuleGenerator {
    private static final String APP_NAME = "inference";

    public void generate(GenerationContext context) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(pipelineMap.values());
        MachineLearningStrategy mlStrategy = new MachineLearningStrategy(pipelines);
        List<String> inferenceModules = mlStrategy.getInferenceModules();
        if (!inferenceModules.isEmpty()) {
            List<PipelineStepPair> pipelineStepPairs = mlStrategy.getInferenceSteps();
            String basefileName = context.getOutputFile();
            for (PipelineStepPair pipelineStepPair : pipelineStepPairs) {
                VelocityContext vc = this.getNewVelocityContext(context);
                String rootArtifactId = context.getRootArtifactId();
                String inferenceDockerArtifactId = this.getArtifactId(context, pipelineStepPair);
                String inferenceModule = this.deriveArtifactIdFromCamelCase(pipelineStepPair.getStep().getName());
                vc.put("rootArtifactId", (Object)rootArtifactId);
                vc.put("artifactId", (Object)inferenceDockerArtifactId);
                vc.put("basePackage", (Object)context.getBasePackage());
                vc.put("parentArtifactId", (Object)context.getArtifactId());
                vc.put("parentDescriptiveName", (Object)context.getDescriptiveName());
                vc.put("inferencePipeline", (Object)pipelineStepPair);
                vc.put("inferenceModuleSnakeCase", (Object)PipelineUtils.deriveLowerSnakeCaseNameFromHyphenatedString(inferenceModule));
                String fileName = this.replace("moduleArtifactId", basefileName, inferenceDockerArtifactId);
                context.setOutputFile(fileName);
                this.generateFile(context, vc);
                this.manualActionNotificationService.addNoticeToAddModuleToParentBuild(context, inferenceDockerArtifactId, "docker");
                String pipelineModule = this.deriveArtifactIdFromCamelCase(pipelineStepPair.getPipeline().getName());
                this.manualActionNotificationService.addDockerBuildWithLiveUpdateTiltFileMessage(context, context.getArtifactId(), inferenceDockerArtifactId, pipelineModule, inferenceModule, false);
                String deployArtifactId = context.getArtifactId().replace("-docker", "-deploy");
                this.manualActionNotificationService.addHelmTiltFileMessage(context, inferenceModule, deployArtifactId);
                this.manualActionNotificationService.addDeployPomMessage(context, "inference-deploy", inferenceModule);
            }
            MlflowDockerModuleGenerator.generateManualMessage(context, mlStrategy);
        }
    }

    protected String getArtifactId(GenerationContext context, PipelineStepPair pipelineStepPair) {
        return context.getArtifactId().replace("-docker", "-" + this.deriveArtifactIdFromCamelCase(pipelineStepPair.getStep().getName()) + "-docker");
    }
}

