/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractResourcesGenerator;
import com.boozallen.aiops.mda.generator.util.PythonGeneratorUtils;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public class InferenceDockerResourcesGenerator
extends AbstractResourcesGenerator {
    private static final Logger logger = LoggerFactory.getLogger(InferenceDockerResourcesGenerator.class);
    protected static final String DOCKER_PROJECT_REPOSITORY_URL = "dockerProjectRepositoryUrl";

    public void generate(GenerationContext context) {
        String rootModuleName = context.getRootArtifactId();
        String dockerProjectRepositoryUrl = (String)context.getPropertyVariables().get(DOCKER_PROJECT_REPOSITORY_URL);
        if (rootModuleName == null || rootModuleName.isEmpty()) {
            logger.error("Root module could not be determined!");
        } else {
            String inferenceModule = context.getArtifactId().replace(rootModuleName + "-", "").replace("-docker", "");
            VelocityContext vc = this.getNewVelocityContext(context);
            vc.put("inferenceModule", (Object)inferenceModule);
            vc.put("inferenceModuleSnakeCase", (Object)PythonGeneratorUtils.normalizeToPythonCase(inferenceModule));
            vc.put(DOCKER_PROJECT_REPOSITORY_URL, (Object)dockerProjectRepositoryUrl);
            this.generateFile(context, vc);
        }
    }
}

