/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.RootFileGenerator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.generator.GenerationException;

public class JteMigrationRootFileGenerator
extends RootFileGenerator {
    private static final Logger logger = LoggerFactory.getLogger(JteMigrationRootFileGenerator.class);

    @Override
    public void generate(GenerationContext generationContext) {
        this.migrateExistingJteFiles(generationContext);
        super.generate(generationContext);
    }

    private void migrateExistingJteFiles(GenerationContext generationContext) {
        File baseJteDirectory = new File(this.getBaseFile(generationContext), "/jte");
        if (baseJteDirectory.exists()) {
            logger.info("");
            logger.info("MIGRATE: ***************************************************************");
            logger.info("MIGRATE: Found existing resources in jte/ - migrating them to devops/...");
            File targetDevopsDirectory = new File(this.getBaseFile(generationContext), "/devops");
            try {
                int fileCount = baseJteDirectory.listFiles().length;
                FileUtils.copyDirectory((File)baseJteDirectory, (File)targetDevopsDirectory);
                this.renameFile(targetDevopsDirectory, "Jenkinsfile", "JenkinsfileBuild.groovy");
                this.renameFile(targetDevopsDirectory, "pipeline_config.groovy", "PipelineConfig.groovy");
                FileUtils.deleteDirectory((File)baseJteDirectory);
                logger.info("MIGRATE: Successfully migrated {} files from jte/ to devops/", (Object)fileCount);
                logger.info("MIGRATE: ***************************************************************");
                logger.info("");
            }
            catch (IOException e) {
                throw new GenerationException("Could not migrate existing jte files!", (Throwable)e);
            }
        }
    }

    private void renameFile(File targetDevopsDirectory, String currentFile, String newFile) {
        File legacyFile = new File(targetDevopsDirectory, currentFile);
        if (legacyFile.exists()) {
            File renamedFile = new File(targetDevopsDirectory, newFile);
            legacyFile.renameTo(renamedFile);
            logger.info("MIGRATE: renamed {} --> {}", (Object)currentFile, (Object)newFile);
        }
    }
}

