/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractKubernetesGenerator;
import java.util.HashSet;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public class KubernetesPortMapGenerator
extends AbstractKubernetesGenerator {
    private static final int PORT_RANGE_MIN = 5000;
    private static final int PORT_NUMBER = 7080;
    private static final int PORT_NUMBER2 = 7081;
    private static final int PORT_RANGE_MAX = 10000;
    private static HashSet<Integer> usedPorts = new HashSet();

    @Override
    protected VelocityContext configureWithoutGeneration(GenerationContext generationContext) {
        VelocityContext vc = super.configureWithoutGeneration(generationContext);
        String appName = (String)vc.get("appName");
        vc.put("appName", (Object)appName);
        vc.put("port1", (Object)this.generateRandomPort(appName, "port1"));
        vc.put("port2", (Object)this.generateRandomPort(appName, "port2"));
        return vc;
    }

    private int findAvailablePort(String portKey, Set<Integer> usedPorts) {
        int port;
        int MAX_ATTEMPTS = 100;
        int attempts = 0;
        while (usedPorts.contains(port = this.generateHashedPort(portKey)) && ++attempts <= 100) {
        }
        if (usedPorts.contains(port)) {
            port = portKey.equals("port1") ? 7080 : 7081;
        }
        return port;
    }

    private int generateRandomPort(String appName, String portKey) {
        int port = this.findAvailablePort(appName + portKey, usedPorts);
        usedPorts.add(port);
        return port;
    }

    private int generateHashedPort(String portKey) {
        int hash = Math.abs(portKey.hashCode());
        return 5000 + hash % 5000;
    }
}

