/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractPythonGenerator;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.PostAction;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.python.MachineLearningPipeline;
import com.boozallen.aiops.mda.metamodel.element.python.PythonStep;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public class MachineLearningPipelineGenerator
extends AbstractPythonGenerator {
    public void generate(GenerationContext context) {
        Pipeline targetPipeline = PipelineUtils.getTargetedPipeline(context, this.metadataContext);
        MachineLearningPipeline mlPipeline = new MachineLearningPipeline(targetPipeline);
        VelocityContext vc = this.getNewVelocityContext(context);
        List genericSteps = mlPipeline.getSteps().stream().takeWhile(PipelineUtils::isGenericStep).map(PythonStep::new).collect(Collectors.toList());
        vc.put("steps", genericSteps);
        vc.put("pipeline", (Object)mlPipeline);
        boolean enableAutoTrain = this.enableAutoTrain(mlPipeline);
        vc.put("autoTrain", (Object)enableAutoTrain);
        vc.put("containsOnnx", (Object)this.pipelineContainsOnnxPostAction(mlPipeline));
        String baseOutputFile = context.getOutputFile();
        String fileName = this.replace("pipelineName", baseOutputFile, mlPipeline.getSnakeCaseName());
        context.setOutputFile(fileName);
        this.generateFile(context, vc);
    }

    private boolean enableAutoTrain(MachineLearningPipeline pipeline) {
        boolean enableAutoTrain = false;
        Step trainingStep = pipeline.getTrainingStep();
        if (trainingStep != null && trainingStep.getInbound() != null) {
            enableAutoTrain = true;
        }
        return enableAutoTrain;
    }

    private boolean pipelineContainsOnnxPostAction(MachineLearningPipeline pipeline) {
        boolean containsOnnx = false;
        if (pipeline.getTrainingStep() != null) {
            for (PostAction postAction : pipeline.getTrainingStep().getPostActions()) {
                if (!PipelineUtils.forOnnxModelConversion(postAction)) continue;
                containsOnnx = true;
                break;
            }
        }
        return containsOnnx;
    }
}

