/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.DockerBuildParams;
import com.boozallen.aiops.mda.generator.AbstractMavenModuleGenerator;
import com.boozallen.aiops.mda.generator.common.DataFlowStrategy;
import com.boozallen.aiops.mda.generator.common.MachineLearningStrategy;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class MlflowDockerPomGenerator
extends AbstractMavenModuleGenerator {
    private static final String MODULE_ARTIFACT_ID = "moduleArtifactId";

    public void generate(GenerationContext context) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
        String basefileName = context.getOutputFile();
        basefileName = this.replaceBasePackage(basefileName, context.getBasePackageAsPath());
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(pipelineMap.values());
        DataFlowStrategy dataFlowStrategy = new DataFlowStrategy(pipelines);
        MachineLearningStrategy mlStrategy = new MachineLearningStrategy(pipelines);
        if (mlStrategy.isMlflowNeeded()) {
            VelocityContext vc = new VelocityContext();
            String rootArtifactId = context.getRootArtifactId();
            String mlflowDockerArtifactId = context.getArtifactId().replace("-docker", "-mlflow-docker");
            vc.put("rootArtifactId", (Object)rootArtifactId);
            vc.put("artifactId", (Object)mlflowDockerArtifactId);
            vc.put("groupId", (Object)context.getGroupId());
            vc.put("basePackage", (Object)context.getBasePackage());
            vc.put("parentArtifactId", (Object)context.getArtifactId());
            vc.put("version", (Object)context.getVersion());
            vc.put("parentDescriptiveName", (Object)context.getDescriptiveName());
            vc.put("trainingPipelines", mlStrategy.getSteps());
            vc.put("enablePostgresSupport", (Object)mlStrategy.isPostgresNeeded());
            vc.put("enableRDBMSSupport", (Object)mlStrategy.isRdbmsSupportNeeded());
            vc.put("useS3Local", (Object)true);
            String fileName = this.replace(MODULE_ARTIFACT_ID, basefileName, mlflowDockerArtifactId);
            context.setOutputFile(fileName);
            this.generateFile(context, vc);
            this.manualActionNotificationService.addNoticeToAddModuleToParentBuild(context, mlflowDockerArtifactId, "docker");
            DockerBuildParams params = new DockerBuildParams.ParamBuilder().setContext(context).setAppName("mlflow-ui").setDockerApplicationArtifactId(mlflowDockerArtifactId).setDockerArtifactId(context.getArtifactId()).build();
            this.manualActionNotificationService.addDockerBuildTiltFileMessage(params);
            this.manualActionNotificationService.addDeployPomMessage(context, "s3local-deploy-v2", "s3-local");
            this.manualActionNotificationService.addDeployPomMessage(context, "aissemble-shared-infrastructure-deploy", "shared-infrastructure");
            this.manualActionNotificationService.addNoticeToUpdateS3LocalConfig(context, "mlflow-models", Arrays.asList("mlflow-storage"));
            if (mlStrategy.isPostgresNeeded() || mlStrategy.isRdbmsSupportNeeded()) {
                this.manualActionNotificationService.addDeployPomMessage(context, "postgres-deploy", "postgres");
            }
        }
    }
}

