/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.technologybrewery.fermenter.mda.generator.AbstractModelAgnosticGenerator;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.generator.GenerationException;

public class PipelineModelGenerator
extends AbstractModelAgnosticGenerator {
    protected String pipelineName = "pipelineName";
    protected String pipelineTypeName = "pipelineTypeName";
    protected String implementationName = "implementationName";
    protected String filePath = "${project.basedir}/${project.artifactId}-pipeline-models/src/main/resources/pipelines/";

    protected String getOutputSubFolder() {
        return "resources/pipelines/";
    }

    public void generate(GenerationContext context) {
        VelocityContext vc = this.getNewVelocityContext(context);
        vc.put("basePackage", (Object)context.getBasePackage());
        Map properties = context.getPropertyVariables();
        vc.put(this.pipelineName, properties.get(this.pipelineName));
        vc.put(this.pipelineTypeName, properties.get(this.pipelineTypeName));
        vc.put(this.implementationName, properties.get(this.implementationName));
        String fileName = this.replace("pipeline", context.getOutputFile(), (String)properties.get("pipelineName"));
        this.filePath = this.replace("project.basedir", this.filePath, (String)properties.get("baseDir"));
        this.filePath = this.replace("project.artifactId", this.filePath, (String)properties.get("baseArtifactName"));
        Template template = context.getEngine().getTemplate(context.getTemplateName());
        File outputFile = new File(this.filePath + fileName);
        outputFile.getParentFile().mkdirs();
        try (FileWriter fw = new FileWriter(outputFile, true);){
            template.merge((Context)vc, (Writer)fw);
        }
        catch (IOException e) {
            throw new GenerationException("Failed to add new module to the project!", (Throwable)e);
        }
    }
}

