/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractMavenModuleGenerator;
import com.boozallen.aiops.mda.generator.common.PersistType;
import com.boozallen.aiops.mda.generator.util.PythonGeneratorUtils;
import com.boozallen.aiops.mda.generator.util.SemanticDataUtil;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.BasePipelineDecorator;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class PipelineModuleGenerator
extends AbstractMavenModuleGenerator {
    public void generate(GenerationContext context) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
        String originalTemplateName = context.getTemplateName();
        String basefileName = context.getOutputFile();
        basefileName = this.replaceBasePackage(basefileName, context.getBasePackageAsPath());
        if (pipelineMap.isEmpty()) {
            this.manualActionNotificationService.addNoticeToAddPipelines(context);
        }
        for (Pipeline pipeline : pipelineMap.values()) {
            VelocityContext vc = new VelocityContext();
            String pipelineName = pipeline.getName();
            vc.put("groupId", (Object)context.getGroupId());
            vc.put("parentArtifactId", (Object)context.getArtifactId());
            vc.put("version", (Object)context.getVersion());
            vc.put("basePackage", (Object)context.getBasePackage());
            String artifactId = this.deriveArtifactIdFromCamelCase(pipelineName);
            vc.put("moduleArtifactId", (Object)artifactId);
            vc.put("moduleArtifactIdPythonCase", (Object)PythonGeneratorUtils.normalizeToPythonCase(artifactId));
            vc.put("parentDescriptiveName", (Object)context.getDescriptiveName());
            String descriptiveName = this.deriveDescriptiveNameFromCamelCase(pipelineName);
            vc.put("descriptiveName", (Object)descriptiveName);
            vc.put("pipeline", (Object)pipeline);
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            boolean enableHiveSupport = pipelineDecorator.isHiveSupportNeeded();
            boolean enableSedonaSupport = pipelineDecorator.isSedonaSupportNeeded();
            boolean enableElasticsearchSupport = pipelineDecorator.isElasticsearchSupportNeeded();
            boolean enableNeo4jSupport = pipelineDecorator.isNeo4jSupportNeeded();
            vc.put("enableHiveSupport", (Object)enableHiveSupport);
            vc.put("enableSedonaSupport", (Object)enableSedonaSupport);
            vc.put("enablePostgresSupport", (Object)pipelineDecorator.isPostgresSupportNeeded());
            vc.put("enableRDBMSSupport", (Object)pipelineDecorator.isRdbmsSupportNeeded());
            vc.put("enableElasticsearchSupport", (Object)enableElasticsearchSupport);
            vc.put("enableNeo4jSupport", (Object)enableNeo4jSupport);
            vc.put("enableSemanticDataSupport", (Object)SemanticDataUtil.hasSemanticDataByContext(this.metadataContext));
            vc.put("projectName", (Object)context.getRootArtifactId());
            vc.put("javaDataRecords", (Object)this.getJavaDataRecordModule(context, SemanticDataUtil.DataRecordModule.COMBINED));
            vc.put("pythonDataRecords", (Object)this.getPythonDataRecordModule(context, SemanticDataUtil.DataRecordModule.COMBINED));
            String fileName = this.replace("moduleArtifactId", basefileName, artifactId);
            context.setOutputFile(fileName);
            this.manualActionNotificationService.addNoticeToAddModuleToParentBuild(context, artifactId, "pipeline");
            String pipelineImplementation = pipeline.getType().getImplementation();
            String pipelineSpecificTemplateName = this.replace("pipelineImplementation", originalTemplateName, pipelineImplementation);
            context.setTemplateName(pipelineSpecificTemplateName);
            this.generateFile(context, vc);
            if (!"data-delivery-spark".equals(pipeline.getType().getImplementation())) continue;
            if (pipelineDecorator.isPostgresSupportNeeded()) {
                this.manualActionNotificationService.addNoticeToAddDependency(context, artifactId, PersistType.POSTGRES.getValue());
            }
            if (pipelineDecorator.isRdbmsSupportNeeded()) {
                this.manualActionNotificationService.addNoticeToAddDependency(context, artifactId, PersistType.RDBMS.getValue());
            }
            if (!enableNeo4jSupport) continue;
            this.manualActionNotificationService.addNoticeToAddDependency(context, artifactId, PersistType.NEO4J.getValue());
        }
    }
}

